/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.archive;

import io.zeebe.containers.archive.ContainerArchiveBuilder;
import io.zeebe.containers.archive.TarExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;

@API(status=API.Status.EXPERIMENTAL)
public final class ContainerArchive {
    private final String archivePath;
    private final GenericContainer<?> container;

    public ContainerArchive(String archivePath, GenericContainer<?> container) {
        this.archivePath = archivePath;
        this.container = container;
    }

    public static ContainerArchiveBuilder builder() {
        return new ContainerArchiveBuilder();
    }

    public void extract(Path destination) {
        this.container.copyFileFromContainer(this.archivePath, rawInput -> this.extractFromInput(destination, (InputStream)rawInput));
    }

    public void transferTo(Path destination) throws IOException {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        this.container.copyFileFromContainer(this.archivePath, input -> Files.copy(input, destination, new CopyOption[0]));
    }

    private Void extractFromInput(Path destination, InputStream rawInput) throws IOException {
        try (GzipCompressorInputStream gzipInput = new GzipCompressorInputStream(rawInput);
             TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)gzipInput);){
            TarExtractor.INSTANCE.extract(tarInput, destination);
        }
        return null;
    }
}

