/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
final class TarExtractor {
    public static final TarExtractor INSTANCE = new TarExtractor();

    TarExtractor() {
    }

    public void extract(TarArchiveInputStream archiveInput, Path destination) throws IOException {
        TarArchiveEntry entry = archiveInput.getNextTarEntry();
        while (entry != null) {
            this.extractEntry(archiveInput, entry, destination);
            entry = archiveInput.getNextTarEntry();
        }
    }

    private void extractEntry(TarArchiveInputStream archiveInput, TarArchiveEntry entry, Path destination) throws IOException {
        if (!archiveInput.canReadEntryData((ArchiveEntry)entry)) {
            throw new IOException(String.format("Expected to extract %s from TAR archive, but data cannot be read; possibly the archive is corrupted", entry));
        }
        Path entryPath = destination.resolve(entry.getName());
        if (!entryPath.normalize().startsWith(destination)) {
            throw new IllegalStateException(String.format("Expected to extract %s from TAR archive to the destination folder %s, but it would be extracted outside to %s; make sure no entry contains `..` or the likes in their name", entry.getName(), destination, entryPath));
        }
        if (entry.isDirectory()) {
            Files.createDirectories(entryPath, new FileAttribute[0]);
            for (TarArchiveEntry childEntry : entry.getDirectoryEntries()) {
                this.extractEntry(archiveInput, childEntry, entryPath);
            }
            return;
        }
        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
        this.writeEntry(archiveInput, entry, entryPath);
    }

    private void writeEntry(TarArchiveInputStream archiveInput, TarArchiveEntry entry, Path destination) throws IOException {
        ReadableByteChannel input = Channels.newChannel((InputStream)archiveInput);
        try (FileChannel output = FileChannel.open(destination, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            output.transferFrom(input, 0L, entry.getRealSize());
            output.force(true);
        }
    }
}

