/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.clock;

import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Logger;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import io.zeebe.containers.clock.ZeebeClock;
import io.zeebe.containers.clock.ZeebeClockClient;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
final class ZeebeClockImpl
implements ZeebeClock {
    private static final Slf4jLogger LOGGER = new Slf4jLogger(ZeebeClockImpl.class);
    private final ZeebeClockClient client;

    ZeebeClockImpl(Target<ZeebeClockClient> target) {
        List<JavaTimeModule> jacksonModules = Collections.singletonList(new JavaTimeModule());
        this.client = (ZeebeClockClient)Feign.builder().encoder((Encoder)new JacksonEncoder(jacksonModules)).decoder((Decoder)new JacksonDecoder(jacksonModules)).logger((Logger)LOGGER).retryer(Retryer.NEVER_RETRY).target(target);
    }

    @Override
    public Instant pinTime(Instant time) {
        long epochMilli = time.toEpochMilli();
        return this.performClientCall(c -> c.pinTime(epochMilli));
    }

    @Override
    public Instant addTime(Duration offset) {
        long offsetMilli = offset.toMillis();
        return this.performClientCall(c -> c.addTime(offsetMilli));
    }

    @Override
    public Instant getCurrentTime() {
        return this.performClientCall(ZeebeClockClient::getCurrentTime);
    }

    @Override
    public Instant resetTime() {
        return this.performClientCall(ZeebeClockClient::resetTime);
    }

    private Instant performClientCall(Function<ZeebeClockClient, ZeebeClockClient.Response> call) {
        try {
            ZeebeClockClient.Response response = call.apply(this.client);
            return response.instant;
        }
        catch (Exception e) {
            throw new ZeebeClock.ZeebeClockException(e);
        }
    }
}

