/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.clock;

import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.clock.ZeebeClockClient;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
final class ZeebeClockTarget
implements Target<ZeebeClockClient> {
    private final ZeebeNode<?> zeebe;
    private final String scheme;

    ZeebeClockTarget(ZeebeNode<?> zeebe) {
        this(zeebe, "http");
    }

    ZeebeClockTarget(ZeebeNode<?> zeebe, String scheme) {
        this.zeebe = zeebe;
        this.scheme = scheme;
    }

    public Class<ZeebeClockClient> type() {
        return ZeebeClockClient.class;
    }

    public String name() {
        return String.format("%s clock", this.zeebe.getInternalHost());
    }

    public String url() {
        return String.format("%s://%s", this.scheme, this.zeebe.getExternalMonitoringAddress());
    }

    public Request apply(RequestTemplate input) {
        input.target(this.url());
        return input.request();
    }
}

