/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.cluster;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeGatewayNode;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.cluster.ZeebeClusterBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

@API(status=API.Status.EXPERIMENTAL)
public class ZeebeCluster
implements Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeCluster.class);
    private final Network network;
    private final String name;
    private final Map<String, ZeebeGatewayNode<? extends GenericContainer<?>>> gateways;
    private final Map<Integer, ZeebeBrokerNode<? extends GenericContainer<?>>> brokers;
    private final int replicationFactor;
    private final int partitionsCount;

    public ZeebeCluster(Network network, String name, Map<String, ZeebeGatewayNode<? extends GenericContainer<?>>> gateways, Map<Integer, ZeebeBrokerNode<? extends GenericContainer<?>>> brokers, int replicationFactor, int partitionsCount) {
        this.network = network;
        this.name = name;
        this.gateways = Collections.unmodifiableMap(gateways);
        this.brokers = Collections.unmodifiableMap(brokers);
        this.replicationFactor = replicationFactor;
        this.partitionsCount = partitionsCount;
    }

    public static ZeebeClusterBuilder builder() {
        return new ZeebeClusterBuilder();
    }

    public void start() {
        LOGGER.info("Starting cluster {} with {} brokers, {} gateways, {} partitions, and a replication factor of {}", new Object[]{this.name, this.brokers.size(), this.gateways.size(), this.partitionsCount, this.replicationFactor});
        Startables.deepStart(this.getClusterContainers()).join();
    }

    public void stop() {
        this.getClusterContainers().forEach(Startable::stop);
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ZeebeGatewayNode<? extends GenericContainer<?>>> getGateways() {
        return this.gateways;
    }

    public Map<Integer, ZeebeBrokerNode<? extends GenericContainer<?>>> getBrokers() {
        return this.brokers;
    }

    public Map<String, ZeebeNode<? extends GenericContainer<?>>> getNodes() {
        HashMap nodes = new HashMap(this.gateways);
        this.brokers.forEach((id, node) -> nodes.put(String.valueOf(id), (ZeebeNode<? extends GenericContainer<?>>)node));
        return nodes;
    }

    public ZeebeClientBuilder newClientBuilder() {
        ZeebeGatewayNode<GenericContainer<?>> gateway = this.getAvailableGateway();
        return ZeebeClient.newClientBuilder().gatewayAddress(gateway.getExternalGatewayAddress()).usePlaintext();
    }

    public ZeebeGatewayNode<? extends GenericContainer<?>> getAvailableGateway() {
        return this.gateways.values().stream().filter(ZeebeNode::isStarted).findAny().orElseThrow(() -> new NoSuchElementException("Expected at least one gateway for the client to connect to, but there is none"));
    }

    private Stream<? extends GenericContainer<?>> getGatewayContainers() {
        return this.gateways.values().stream().map(Container::self);
    }

    private Stream<? extends GenericContainer<?>> getBrokerContainers() {
        return this.brokers.values().stream().map(Container::self);
    }

    private Stream<GenericContainer<? extends GenericContainer<?>>> getClusterContainers() {
        return Stream.concat(this.getBrokerContainers(), this.getGatewayContainers()).distinct();
    }
}

