/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.cluster;

import io.zeebe.containers.ZeebeBrokerContainer;
import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeContainer;
import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.ZeebeGatewayContainer;
import io.zeebe.containers.ZeebeGatewayNode;
import io.zeebe.containers.ZeebeNode;
import io.zeebe.containers.ZeebeTopologyWaitStrategy;
import io.zeebe.containers.cluster.ZeebeCluster;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

@API(status=API.Status.EXPERIMENTAL)
public class ZeebeClusterBuilder {
    private static final String BROKER_NETWORK_ALIAS_PREFIX = "zeebe-broker-";
    private static final String GATEWAY_NETWORK_ALIAS_PREFIX = "zeebe-gateway-";
    private static final String DEFAULT_CLUSTER_NAME = "zeebe-cluster";
    private Network network = Network.SHARED;
    private String name = "zeebe-cluster";
    private int gatewaysCount = 0;
    private int brokersCount = 1;
    private int partitionsCount = 1;
    private int replicationFactor = 1;
    private boolean useEmbeddedGateway = true;
    private DockerImageName gatewayImageName = ZeebeDefaults.getInstance().getDefaultDockerImage();
    private DockerImageName brokerImageName = ZeebeDefaults.getInstance().getDefaultDockerImage();
    private Consumer<ZeebeNode<?>> nodeConfig = cfg -> {};
    private BiConsumer<Integer, ZeebeBrokerNode<?>> brokerConfig = (id, cfg) -> {};
    private BiConsumer<String, ZeebeGatewayNode<?>> gatewayConfig = (memberId, cfg) -> {};
    private final Map<String, ZeebeGatewayNode<? extends GenericContainer<?>>> gateways = new HashMap();
    private final Map<Integer, ZeebeBrokerNode<? extends GenericContainer<?>>> brokers = new HashMap();

    public ZeebeClusterBuilder withEmbeddedGateway(boolean useEmbeddedGateway) {
        this.useEmbeddedGateway = useEmbeddedGateway;
        return this;
    }

    public ZeebeClusterBuilder withGatewaysCount(int gatewaysCount) {
        this.gatewaysCount = gatewaysCount;
        return this;
    }

    public ZeebeClusterBuilder withBrokersCount(int brokersCount) {
        if (brokersCount < 0) {
            throw new IllegalArgumentException("Expected brokersCount to be at least 0, but was " + brokersCount);
        }
        this.brokersCount = brokersCount;
        if (brokersCount > 0) {
            this.partitionsCount = Math.max(this.partitionsCount, 1);
            this.replicationFactor = Math.max(this.replicationFactor, 1);
        } else {
            this.partitionsCount = 0;
            this.replicationFactor = 0;
        }
        return this;
    }

    public ZeebeClusterBuilder withPartitionsCount(int partitionsCount) {
        if (partitionsCount <= 0) {
            throw new IllegalArgumentException("Expected partitionsCount to be at least 1, but was " + partitionsCount);
        }
        this.partitionsCount = partitionsCount;
        return this;
    }

    public ZeebeClusterBuilder withReplicationFactor(int replicationFactor) {
        if (replicationFactor <= 0) {
            throw new IllegalArgumentException("Expected replicationFactor to be at least 1, but was " + replicationFactor);
        }
        this.replicationFactor = replicationFactor;
        return this;
    }

    public ZeebeClusterBuilder withNetwork(Network network) {
        this.network = Objects.requireNonNull(network);
        return this;
    }

    public ZeebeClusterBuilder withName(String name) {
        if (name == null || name.trim().length() < 3) {
            throw new IllegalArgumentException("Expected cluster name to be at least 3 characters, but was " + name);
        }
        this.name = name;
        return this;
    }

    public ZeebeClusterBuilder withGatewayImage(DockerImageName gatewayImageName) {
        this.gatewayImageName = Objects.requireNonNull(gatewayImageName);
        return this;
    }

    public ZeebeClusterBuilder withBrokerImage(DockerImageName brokerImageName) {
        this.brokerImageName = Objects.requireNonNull(brokerImageName);
        return this;
    }

    public ZeebeClusterBuilder withImage(DockerImageName imageName) {
        return this.withGatewayImage(imageName).withBrokerImage(imageName);
    }

    public ZeebeClusterBuilder withNodeConfig(Consumer<ZeebeNode<?>> nodeCfgFunction) {
        this.nodeConfig = nodeCfgFunction;
        return this;
    }

    public ZeebeClusterBuilder withGatewayConfig(BiConsumer<String, ZeebeGatewayNode<?>> gatewayCfgFunction) {
        this.gatewayConfig = gatewayCfgFunction;
        return this;
    }

    public ZeebeClusterBuilder withGatewayConfig(Consumer<ZeebeGatewayNode<?>> gatewayCfgFunction) {
        this.gatewayConfig = (memberId, gateway) -> gatewayCfgFunction.accept((ZeebeGatewayNode<?>)gateway);
        return this;
    }

    public ZeebeClusterBuilder withBrokerConfig(BiConsumer<Integer, ZeebeBrokerNode<?>> brokerCfgFunction) {
        this.brokerConfig = brokerCfgFunction;
        return this;
    }

    public ZeebeClusterBuilder withBrokerConfig(Consumer<ZeebeBrokerNode<?>> brokerCfgFunction) {
        this.brokerConfig = (id, broker) -> brokerCfgFunction.accept((ZeebeBrokerNode<?>)broker);
        return this;
    }

    public ZeebeCluster build() {
        this.gateways.clear();
        this.brokers.clear();
        this.validate();
        this.createBrokers();
        this.createStandaloneGateways();
        this.brokers.forEach(this::applyConfigFunctions);
        this.gateways.forEach((memberId, gateway) -> {
            if (!(gateway instanceof ZeebeBrokerNode)) {
                this.applyConfigFunctions(memberId, (ZeebeNode<?>)gateway);
            }
        });
        return new ZeebeCluster(this.network, this.name, this.gateways, this.brokers, this.replicationFactor, this.partitionsCount);
    }

    private void applyConfigFunctions(Object id, ZeebeNode<?> node) {
        this.nodeConfig.accept(node);
        if (node instanceof ZeebeGatewayNode) {
            this.gatewayConfig.accept(String.valueOf(id), (ZeebeGatewayNode)node);
        }
        if (node instanceof ZeebeBrokerNode) {
            this.brokerConfig.accept((Integer)id, (ZeebeBrokerNode)node);
        }
    }

    private void validate() {
        if (this.replicationFactor > this.brokersCount) {
            throw new IllegalStateException("Expected replicationFactor to be less than or equal to brokersCount, but was " + this.replicationFactor + " > " + this.brokersCount);
        }
        if (this.brokersCount > 0) {
            if (this.partitionsCount < 1) {
                throw new IllegalStateException("Expected to have at least one partition if there are any brokers, but partitionsCount was " + this.partitionsCount);
            }
            if (this.replicationFactor < 1) {
                throw new IllegalStateException("Expected to have replication factor at least 1 if there are any brokers, but replicationFactor was " + this.replicationFactor);
            }
        }
    }

    private void createBrokers() {
        for (int i = 0; i < this.brokersCount; ++i) {
            GenericContainer broker;
            if (this.useEmbeddedGateway) {
                ZeebeContainer container = new ZeebeContainer(this.brokerImageName);
                this.configureGateway(container);
                broker = container;
                this.gateways.put(String.valueOf(i), container);
            } else {
                broker = new ZeebeBrokerContainer(this.brokerImageName);
            }
            this.configureBroker((ZeebeBrokerNode<?>)broker, i);
            this.brokers.put(i, (ZeebeBrokerNode<GenericContainer<?>>)broker);
        }
        this.configureBrokerInitialContactPoints();
    }

    private void createStandaloneGateways() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < this.gatewaysCount; ++i) {
            String memberId = GATEWAY_NETWORK_ALIAS_PREFIX + i;
            ZeebeGatewayContainer gateway = this.createStandaloneGateway(memberId);
            gateway.withStartupTimeout(Duration.ofMinutes((long)this.gatewaysCount + (long)this.brokersCount));
            if (this.brokersCount <= 0) continue;
            ZeebeBrokerNode<? extends GenericContainer<?>> contactPoint = this.brokers.get(random.nextInt(0, this.brokers.size()));
            ((ZeebeGatewayContainer)gateway.dependsOn(new Startable[]{(Startable)contactPoint.self()})).withEnv("ZEEBE_GATEWAY_CLUSTER_CONTACTPOINT", contactPoint.getInternalClusterAddress());
        }
    }

    private ZeebeGatewayContainer createStandaloneGateway(String memberId) {
        ZeebeGatewayContainer gateway = new ZeebeGatewayContainer(this.gatewayImageName);
        ((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)((ZeebeGatewayContainer)gateway.withNetwork(this.network)).withNetworkAliases(new String[]{memberId})).withEnv("ZEEBE_GATEWAY_CLUSTER_CLUSTERNAME", this.name)).withEnv("ZEEBE_GATEWAY_CLUSTER_HOST", gateway.getInternalHost())).withEnv("ZEEBE_GATEWAY_CLUSTER_MEMBERID", memberId);
        this.configureGateway(gateway);
        this.gateways.put(memberId, gateway);
        return gateway;
    }

    private void configureGateway(ZeebeGatewayNode<?> gateway) {
        gateway.withTopologyCheck(new ZeebeTopologyWaitStrategy().forBrokersCount(this.brokersCount).forPartitionsCount(this.partitionsCount).forReplicationFactor(this.replicationFactor));
    }

    private void configureBroker(ZeebeBrokerNode<?> broker, int index) {
        String hostName = BROKER_NETWORK_ALIAS_PREFIX + index;
        ((GenericContainer)broker.withNetwork(this.network)).withNetworkAliases(new String[]{hostName}).withEnv("ZEEBE_BROKER_NETWORK_ADVERTISEDHOST", broker.getInternalHost()).withEnv("ZEEBE_BROKER_CLUSTER_CLUSTERNAME", this.name).withEnv("ZEEBE_BROKER_CLUSTER_NODEID", String.valueOf(index)).withEnv("ZEEBE_BROKER_CLUSTER_CLUSTERSIZE", String.valueOf(this.brokersCount)).withEnv("ZEEBE_BROKER_CLUSTER_REPLICATIONFACTOR", String.valueOf(this.replicationFactor)).withEnv("ZEEBE_BROKER_CLUSTER_PARTITIONSCOUNT", String.valueOf(this.partitionsCount)).withStartupTimeout(Duration.ofMinutes((long)this.brokersCount + (long)this.gatewaysCount));
    }

    private void configureBrokerInitialContactPoints() {
        String initialContactPoints = this.brokers.values().stream().map(ZeebeNode::getInternalClusterAddress).collect(Collectors.joining(","));
        this.brokers.values().forEach(b -> b.withEnv("ZEEBE_BROKER_CLUSTER_INITIALCONTACTPOINTS", initialContactPoints));
    }
}

