/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.util;

import java.util.HashMap;
import java.util.Map;
import org.agrona.collections.MutableInteger;
import org.apiguardian.api.API;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.Testcontainers;

@API(status=API.Status.INTERNAL)
public final class HostPortForwarder {
    private final PortForwarder portForwarder;

    public HostPortForwarder() {
        this(Testcontainers::exposeHostPorts);
    }

    public HostPortForwarder(PortForwarder portForwarder) {
        this.portForwarder = portForwarder;
    }

    public static int forwardHostPort(int port, int retryCount) {
        return new HostPortForwarder().forward(port, retryCount);
    }

    public int forward(int port, int retryCount) {
        MutableInteger attempts = new MutableInteger();
        return (Integer)Unreliables.retryUntilSuccess((int)retryCount, () -> {
            int containerPort = port + attempts.getAndIncrement();
            HashMap<Integer, Integer> portMapping = new HashMap<Integer, Integer>();
            portMapping.put(port, containerPort);
            this.portForwarder.forwardPort(portMapping);
            return containerPort;
        });
    }

    @FunctionalInterface
    public static interface PortForwarder {
        public void forwardPort(Map<Integer, Integer> var1);
    }
}

