/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.Tracer;
import brave.jms.JmsTracing;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

final class TracingExceptionListener {
    TracingExceptionListener() {
    }

    static ExceptionListener create(JmsTracing jmsTracing) {
        return new TagError(jmsTracing.tracing.tracer());
    }

    static ExceptionListener create(ExceptionListener delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("exceptionListener == null");
        }
        if (delegate instanceof TagError) {
            return delegate;
        }
        return new DelegateAndTagError(delegate, jmsTracing.tracing.tracer());
    }

    static final class DelegateAndTagError
    extends TagError {
        final ExceptionListener delegate;

        DelegateAndTagError(ExceptionListener delegate, Tracer tracer) {
            super(tracer);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(JMSException exception) {
            Span span = this.tracer.currentSpan();
            if (span == null) {
                this.delegate.onException(exception);
                return;
            }
            Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
            try {
                this.delegate.onException(exception);
            }
            finally {
                span.error((Throwable)exception);
                scope.close();
            }
        }
    }

    static class TagError
    implements ExceptionListener {
        final Tracer tracer;

        TagError(Tracer tracer) {
            this.tracer = tracer;
        }

        public void onException(JMSException exception) {
            Span span = this.tracer.currentSpan();
            if (span != null) {
                span.error((Throwable)exception);
            }
        }
    }
}

