/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.otel.brave;

import brave.Span;
import brave.Tag;
import brave.handler.MutableSpan;
import brave.http.HttpTags;
import com.google.protobuf.ByteString;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.ScopeSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.proto.trace.v1.TracesData;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import zipkin2.reporter.otel.brave.BraveScope;

final class SpanTranslator {
    static final String PEER_SERVICE = "peer.service";
    static final ByteString INVALID_TRACE_ID = ByteString.fromHex((String)"00000000000000000000000000000000");
    static final ByteString INVALID_SPAN_ID = ByteString.fromHex((String)"0000000000000000");
    static final String DEFAULT_SPAN_NAME = "unknown";
    static final Span.SpanKind DEFAULT_KIND = Span.SpanKind.SPAN_KIND_INTERNAL;
    static final String DEFAULT_SERVICE_NAME = "unknown_service:java";
    static final Map<String, String> TAG_TO_ATTRIBUTE = new LinkedHashMap<String, String>();
    private final TagMapper tagMapper;
    private final Map<String, String> resourceAttributes;

    SpanTranslator(Tag<Throwable> errorTag, Map<String, String> resourceAttributes) {
        this.tagMapper = new TagMapper(errorTag, TAG_TO_ATTRIBUTE);
        this.resourceAttributes = resourceAttributes;
    }

    TracesData translate(MutableSpan braveSpan) {
        TracesData.Builder tracesDataBuilder = TracesData.newBuilder();
        ResourceSpans.Builder resourceSpansBuilder = ResourceSpans.newBuilder();
        ScopeSpans.Builder scopeSpanBuilder = ScopeSpans.newBuilder();
        Span.Builder spanBuilder = this.builderForSingleSpan(braveSpan, resourceSpansBuilder);
        scopeSpanBuilder.addSpans(spanBuilder.build());
        InstrumentationScope.Builder scopeBuilder = InstrumentationScope.newBuilder();
        scopeBuilder.setName(BraveScope.NAME);
        scopeBuilder.setVersion(BraveScope.VERSION);
        scopeSpanBuilder.setScope(scopeBuilder.build());
        resourceSpansBuilder.addScopeSpans(scopeSpanBuilder.build());
        tracesDataBuilder.addResourceSpans(resourceSpansBuilder.build());
        return tracesDataBuilder.build();
    }

    private Span.Builder builderForSingleSpan(MutableSpan span, ResourceSpans.Builder resourceSpansBuilder) {
        Span.Builder spanBuilder = Span.newBuilder().setTraceId(span.traceId() != null ? ByteString.fromHex((String)span.traceId()) : INVALID_TRACE_ID).setSpanId(span.id() != null ? ByteString.fromHex((String)span.id()) : INVALID_SPAN_ID).setName(span.name() == null || span.name().isEmpty() ? DEFAULT_SPAN_NAME : span.name());
        if (span.parentId() != null) {
            spanBuilder.setParentSpanId(ByteString.fromHex((String)span.parentId()));
        }
        long start = span.startTimestamp();
        long finish = span.finishTimestamp();
        spanBuilder.setStartTimeUnixNano(TimeUnit.MICROSECONDS.toNanos(start));
        spanBuilder.setEndTimeUnixNano(TimeUnit.MICROSECONDS.toNanos(finish));
        spanBuilder.setKind(SpanTranslator.translateKind(span.kind()));
        Resource.Builder resourceBuilder = resourceSpansBuilder.getResourceBuilder();
        if (!this.resourceAttributes.containsKey(ServiceAttributes.SERVICE_NAME.getKey())) {
            String localServiceName = span.localServiceName();
            if (localServiceName == null || localServiceName.isEmpty()) {
                localServiceName = DEFAULT_SERVICE_NAME;
            }
            resourceBuilder.addAttributes(SpanTranslator.stringAttribute(ServiceAttributes.SERVICE_NAME.getKey(), localServiceName));
        }
        this.resourceAttributes.forEach((k, v) -> resourceBuilder.addAttributes(SpanTranslator.stringAttribute(k, v)));
        SpanTranslator.maybeAddStringAttribute(spanBuilder, NetworkAttributes.NETWORK_LOCAL_ADDRESS.getKey(), span.localIp());
        SpanTranslator.maybeAddIntAttribute(spanBuilder, NetworkAttributes.NETWORK_LOCAL_PORT.getKey(), span.localPort());
        SpanTranslator.maybeAddStringAttribute(spanBuilder, NetworkAttributes.NETWORK_PEER_ADDRESS.getKey(), span.remoteIp());
        SpanTranslator.maybeAddIntAttribute(spanBuilder, NetworkAttributes.NETWORK_PEER_PORT.getKey(), span.remotePort());
        SpanTranslator.maybeAddStringAttribute(spanBuilder, PEER_SERVICE, span.remoteServiceName());
        span.forEachTag((MutableSpan.TagConsumer)this.tagMapper, (Object)spanBuilder);
        span.forEachAnnotation((MutableSpan.AnnotationConsumer)this.tagMapper, (Object)spanBuilder);
        this.tagMapper.addErrorTag(spanBuilder, span);
        return spanBuilder;
    }

    private static Span.SpanKind translateKind(Span.Kind kind) {
        if (kind != null) {
            switch (kind) {
                case CLIENT: {
                    return Span.SpanKind.SPAN_KIND_CLIENT;
                }
                case SERVER: {
                    return Span.SpanKind.SPAN_KIND_SERVER;
                }
                case PRODUCER: {
                    return Span.SpanKind.SPAN_KIND_PRODUCER;
                }
                case CONSUMER: {
                    return Span.SpanKind.SPAN_KIND_CONSUMER;
                }
            }
        }
        return DEFAULT_KIND;
    }

    static KeyValue stringAttribute(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build();
    }

    static KeyValue intAttribute(String key, int value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setIntValue((long)value)).build();
    }

    private static void maybeAddStringAttribute(Span.Builder spanBuilder, String key, String value) {
        if (value != null) {
            spanBuilder.addAttributes(SpanTranslator.stringAttribute(key, value));
        }
    }

    private static void maybeAddIntAttribute(Span.Builder spanBuilder, String key, int value) {
        if (value != 0) {
            spanBuilder.addAttributes(SpanTranslator.intAttribute(key, value));
        }
    }

    static {
        TAG_TO_ATTRIBUTE.put("http.host", ServerAttributes.SERVER_ADDRESS.getKey());
        TAG_TO_ATTRIBUTE.put(HttpTags.METHOD.key(), HttpAttributes.HTTP_REQUEST_METHOD.getKey());
        TAG_TO_ATTRIBUTE.put(HttpTags.PATH.key(), UrlAttributes.URL_PATH.getKey());
        TAG_TO_ATTRIBUTE.put(HttpTags.ROUTE.key(), HttpAttributes.HTTP_ROUTE.getKey());
        TAG_TO_ATTRIBUTE.put(HttpTags.URL.key(), UrlAttributes.URL_FULL.getKey());
        TAG_TO_ATTRIBUTE.put(HttpTags.STATUS_CODE.key(), HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey());
    }

    static final class TagMapper
    implements MutableSpan.TagConsumer<Span.Builder>,
    MutableSpan.AnnotationConsumer<Span.Builder> {
        final Tag<Throwable> errorTag;
        final Map<String, String> tagToAttribute;

        TagMapper(Tag<Throwable> errorTag, Map<String, String> tagToAttribute) {
            this.errorTag = errorTag;
            this.tagToAttribute = tagToAttribute;
        }

        public void accept(Span.Builder target, String tagKey, String value) {
            target.addAttributes(SpanTranslator.stringAttribute(this.convertTagToAttribute(tagKey), value));
        }

        void addErrorTag(Span.Builder target, MutableSpan span) {
            String errorValue = this.errorTag.value((Object)span.error(), null);
            if (errorValue != null) {
                target.addAttributes(SpanTranslator.stringAttribute("error", errorValue));
                target.setStatus(Status.newBuilder().setCode(Status.StatusCode.STATUS_CODE_ERROR).build());
            } else {
                target.setStatus(Status.newBuilder().setCode(Status.StatusCode.STATUS_CODE_OK).build());
            }
        }

        public void accept(Span.Builder target, long timestamp, String value) {
            target.addEvents(Span.Event.newBuilder().setTimeUnixNano(TimeUnit.MICROSECONDS.toNanos(timestamp)).setName(value).build());
        }

        private String convertTagToAttribute(String tagKey) {
            String attributeKey = this.tagToAttribute.get(tagKey);
            return attributeKey != null ? attributeKey : tagKey;
        }
    }
}

