/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.kafka11;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AwaitableCallback;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

public final class KafkaSender
extends Sender {
    final Properties properties = new Properties();
    final String topic;
    final Encoding encoding;
    final BytesMessageEncoder encoder;
    final int messageMaxBytes;
    volatile KafkaProducer<byte[], byte[]> producer;
    volatile boolean closeCalled;

    public static KafkaSender create(String bootstrapServers) {
        return KafkaSender.newBuilder().bootstrapServers(bootstrapServers).build();
    }

    public static Builder newBuilder() {
        Properties properties = new Properties();
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("acks", "0");
        return new Builder(properties);
    }

    KafkaSender(Builder builder) {
        this.properties.putAll((Map<?, ?>)builder.properties);
        this.topic = builder.topic;
        this.encoding = builder.encoding;
        this.encoder = BytesMessageEncoder.forEncoding((Encoding)builder.encoding);
        this.messageMaxBytes = builder.messageMaxBytes;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding.listSizeInBytes(encodedSpans);
    }

    public int messageSizeInBytes(int encodedSizeInBytes) {
        return this.encoding.listSizeInBytes(encodedSizeInBytes);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        byte[] message = this.encoder.encode(encodedSpans);
        return new KafkaCall(message);
    }

    public CheckResult check() {
        try {
            this.get().partitionsFor(this.topic);
            return CheckResult.OK;
        }
        catch (RuntimeException e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KafkaProducer<byte[], byte[]> get() {
        if (this.producer == null) {
            KafkaSender kafkaSender = this;
            synchronized (kafkaSender) {
                if (this.producer == null) {
                    this.producer = new KafkaProducer(this.properties);
                }
            }
        }
        return this.producer;
    }

    public synchronized void close() {
        if (this.closeCalled) {
            return;
        }
        KafkaProducer<byte[], byte[]> producer = this.producer;
        if (producer != null) {
            producer.close();
        }
        this.closeCalled = true;
    }

    public final String toString() {
        return "KafkaSender{bootstrapServers=" + this.properties.get("bootstrap.servers") + ", topic=" + this.topic + "}";
    }

    static final class CallbackAdapter
    implements org.apache.kafka.clients.producer.Callback {
        final Callback<Void> delegate;

        CallbackAdapter(Callback<Void> delegate) {
            this.delegate = delegate;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception == null) {
                this.delegate.onSuccess(null);
            } else {
                this.delegate.onError((Throwable)exception);
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    class KafkaCall
    extends Call.Base<Void> {
        private final byte[] message;

        KafkaCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            AwaitableCallback callback = new AwaitableCallback();
            KafkaSender.this.get().send(new ProducerRecord(KafkaSender.this.topic, (Object)this.message), (org.apache.kafka.clients.producer.Callback)new CallbackAdapter((Callback<Void>)callback));
            callback.await();
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            KafkaSender.this.get().send(new ProducerRecord(KafkaSender.this.topic, (Object)this.message), (org.apache.kafka.clients.producer.Callback)new CallbackAdapter(callback));
        }

        public Call<Void> clone() {
            return new KafkaCall(this.message);
        }
    }

    public static final class Builder {
        final Properties properties;
        Encoding encoding = Encoding.JSON;
        String topic = "zipkin";
        int messageMaxBytes = 1000000;

        Builder(Properties properties) {
            this.properties = properties;
        }

        Builder(KafkaSender sender) {
            this.properties = new Properties();
            this.properties.putAll((Map<?, ?>)sender.properties);
            this.encoding = sender.encoding;
            this.topic = sender.topic;
            this.messageMaxBytes = sender.messageMaxBytes;
        }

        public Builder topic(String topic) {
            if (topic == null) {
                throw new NullPointerException("topic == null");
            }
            this.topic = topic;
            return this;
        }

        public final Builder bootstrapServers(String bootstrapServers) {
            if (bootstrapServers == null) {
                throw new NullPointerException("bootstrapServers == null");
            }
            this.properties.put("bootstrap.servers", bootstrapServers);
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final Builder overrides(Map<String, ?> overrides) {
            if (overrides == null) {
                throw new NullPointerException("overrides == null");
            }
            this.properties.putAll(overrides);
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public KafkaSender build() {
            return new KafkaSender(this);
        }
    }
}

