/*
	* Copyright (C) 2003-2017 Sebastiano Vigna
	*
	* Licensed under the Apache License, Version 2.0 (the "License");
	* you may not use this file except in compliance with the License.
	* You may obtain a copy of the License at
	*
	*     http://www.apache.org/licenses/LICENSE-2.0
	*
	* Unless required by applicable law or agreed to in writing, software
	* distributed under the License is distributed on an "AS IS" BASIS,
	* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	* See the License for the specific language governing permissions and
	* limitations under the License.
	*/
package it.unimi.dsi.fastutil.bytes;

/**
 * An abstract class providing basic methods for sorted sets implementing a
 * type-specific interface.
 */
public abstract class AbstractByteSortedSet extends AbstractByteSet implements ByteSortedSet {
	protected AbstractByteSortedSet() {
	}

	/**
	 * {@inheritDoc}
	 *
	 * <p>
	 * This implementation delegates to the new covariantly stronger generic
	 * method {@link #iterator()}.
	 * 
	 * @deprecated As of <code>fastutil</code> 5, replaced by
	 *             {@link #iterator()}.
	 */
	@Deprecated
	@Override
	public ByteBidirectionalIterator byteIterator() {
		return iterator();
	}

	@Override
	public abstract ByteBidirectionalIterator iterator();

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ByteSortedSet headSet(final Byte to) {
		return headSet(to.byteValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ByteSortedSet tailSet(final Byte from) {
		return tailSet(from.byteValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public ByteSortedSet subSet(final Byte from, final Byte to) {
		return subSet(from.byteValue(), to.byteValue());
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public Byte first() {
		return (Byte.valueOf(firstByte()));
	}

	/**
	 * {@inheritDoc}
	 * <p>
	 * This implementation delegates to the corresponding type-specific method.
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	public Byte last() {
		return (Byte.valueOf(lastByte()));
	}
}
