/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.qoomon.gitversioning.GitRepoSituation;
import me.qoomon.gitversioning.GitVersionDetails;
import me.qoomon.gitversioning.PropertyDescription;
import me.qoomon.gitversioning.StringUtil;
import me.qoomon.gitversioning.VersionDescription;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class GitVersioning {
    public static final String VERSION_DATE_TIME_FORMAT = "yyyyMMdd.HHmmss";
    public static final String NO_COMMIT_DATE = "00000000.000000";

    private GitVersioning() {
    }

    public static GitVersionDetails determineVersion(GitRepoSituation repoSituation, VersionDescription commitVersionDescription, List<VersionDescription> branchVersionDescriptions, List<VersionDescription> tagVersionDescriptions, boolean preferTags) {
        Objects.requireNonNull(repoSituation);
        Objects.requireNonNull(commitVersionDescription);
        Objects.requireNonNull(branchVersionDescriptions);
        Objects.requireNonNull(tagVersionDescriptions);
        VersioningInfo versioningInfo = GitVersioning.getVersioningInfo(repoSituation, commitVersionDescription, branchVersionDescriptions, tagVersionDescriptions, preferTags);
        Map<String, String> refData = StringUtil.valueGroupMap(versioningInfo.description.getPattern(), versioningInfo.gitRefName);
        HashMap<String, String> gitDataMap = new HashMap<String, String>();
        gitDataMap.put("commit", repoSituation.getHeadCommit());
        gitDataMap.put("commit.short", repoSituation.getHeadCommit().substring(0, 7));
        gitDataMap.put("commit.timestamp", Long.toString(repoSituation.getHeadCommitTimestamp()));
        gitDataMap.put("commit.timestamp.datetime", GitVersioning.toTimestampDateTime(repoSituation.getHeadCommitTimestamp()));
        gitDataMap.put("ref", versioningInfo.gitRefName);
        gitDataMap.put(versioningInfo.gitRefType, versioningInfo.gitRefName);
        gitDataMap.putAll(refData);
        GitVersionDetails.VersionTransformer versionTransformer = currentVersion -> {
            HashMap<String, String> dataMap = new HashMap<String, String>(gitDataMap);
            dataMap.put("version", currentVersion);
            dataMap.put("version.release", currentVersion.replaceFirst("-SNAPSHOT$", ""));
            return StringUtil.substituteText(versioningInfo.description.getVersionFormat(), dataMap).replace("/", "-");
        };
        GitVersionDetails.PropertiesTransformer propertiesTransformer = (currentProperties, currentVersion) -> {
            HashMap<String, String> dataMap = new HashMap<String, String>(gitDataMap);
            dataMap.put("version", currentVersion);
            dataMap.put("version.release", currentVersion.replaceFirst("-SNAPSHOT$", ""));
            return GitVersioning.transformProperties(currentProperties, versioningInfo.description.getPropertyDescriptions(), dataMap);
        };
        return new GitVersionDetails(repoSituation.isClean(), repoSituation.getHeadCommit(), versioningInfo.gitRefType, versioningInfo.gitRefName, repoSituation.getHeadCommitTimestamp(), versionTransformer, propertiesTransformer);
    }

    private static VersioningInfo getVersioningInfo(GitRepoSituation repoSituation, VersionDescription commitVersionDescription, List<VersionDescription> branchVersionDescriptions, List<VersionDescription> tagVersionDescriptions, boolean preferTags) {
        VersioningInfo versioningInfo = null;
        if (preferTags) {
            versioningInfo = GitVersioning.getTagVersioningInfo(repoSituation, tagVersionDescriptions);
        }
        if (versioningInfo == null) {
            versioningInfo = GitVersioning.getBranchVersioningInfo(repoSituation, branchVersionDescriptions);
        }
        if (versioningInfo == null && !preferTags) {
            versioningInfo = GitVersioning.getTagVersioningInfo(repoSituation, tagVersionDescriptions);
        }
        if (versioningInfo == null) {
            versioningInfo = new VersioningInfo("commit", repoSituation.getHeadCommit(), commitVersionDescription);
        }
        return versioningInfo;
    }

    private static VersioningInfo getTagVersioningInfo(GitRepoSituation repoSituation, List<VersionDescription> tagVersionDescriptions) {
        if (!repoSituation.getHeadTags().isEmpty()) {
            for (VersionDescription tagVersionDescription : tagVersionDescriptions) {
                Optional<String> versionTag = repoSituation.getHeadTags().stream().filter(tag -> tag.matches(tagVersionDescription.getPattern())).max(Comparator.comparing(DefaultArtifactVersion::new));
                if (!versionTag.isPresent()) continue;
                return new VersioningInfo("tag", versionTag.get(), tagVersionDescription);
            }
        }
        return null;
    }

    private static VersioningInfo getBranchVersioningInfo(GitRepoSituation repoSituation, List<VersionDescription> branchVersionDescriptions) {
        if (repoSituation.getHeadBranch() != null) {
            for (VersionDescription branchVersionDescription : branchVersionDescriptions) {
                Optional<String> versionBranch = Optional.of(repoSituation.getHeadBranch()).filter(branch -> branch.matches(branchVersionDescription.getPattern()));
                if (!versionBranch.isPresent()) continue;
                return new VersioningInfo("branch", versionBranch.get(), branchVersionDescription);
            }
        }
        return null;
    }

    private static Map<String, String> transformProperties(Map<String, String> currentProperties, List<PropertyDescription> propertyDescriptions, Map<String, String> dataMap) {
        HashMap<String, String> resultProperties = new HashMap<String, String>(currentProperties);
        for (Map.Entry<String, String> property : currentProperties.entrySet()) {
            Optional<PropertyDescription> propertyDescription = propertyDescriptions.stream().filter(it -> ((String)property.getKey()).matches(it.getPattern())).findFirst();
            if (!propertyDescription.isPresent()) continue;
            String valuePattern = propertyDescription.get().getValueDescription().getPattern();
            if (!property.getValue().matches(valuePattern)) continue;
            HashMap<String, String> propertyDataMap = new HashMap<String, String>(dataMap);
            propertyDataMap.put("property.name", property.getKey());
            propertyDataMap.put("property.value", property.getValue());
            Map<String, String> propertyFields = StringUtil.valueGroupMap(valuePattern, property.getValue());
            propertyDataMap.putAll(propertyFields);
            String valueFormat = propertyDescription.get().getValueDescription().getFormat();
            String resultValue = StringUtil.substituteText(valueFormat, propertyDataMap);
            resultProperties.replace(property.getKey(), resultValue);
        }
        return resultProperties;
    }

    private static String toTimestampDateTime(long timestamp) {
        if (timestamp == 0L) {
            return NO_COMMIT_DATE;
        }
        return DateTimeFormatter.ofPattern(VERSION_DATE_TIME_FORMAT).withZone(ZoneOffset.UTC).format(Instant.ofEpochSecond(timestamp));
    }

    private static class VersioningInfo {
        private final String gitRefType;
        private final String gitRefName;
        private final VersionDescription description;

        private VersioningInfo(String gitRefType, String gitRefName, VersionDescription versionDescription) {
            this.gitRefType = gitRefType;
            this.gitRefName = gitRefName;
            this.description = versionDescription;
        }
    }
}

