/*
 * Decompiled with CFR 0.152.
 */
package vagrant.impl.cli;

import java.io.File;
import java.util.Collection;
import vagrant.api.BoxApi;
import vagrant.api.CommandIOListener;
import vagrant.api.VagrantApi;
import vagrant.api.domain.Machine;
import vagrant.api.domain.SshConfig;
import vagrant.impl.cli.BoxImpl;
import vagrant.impl.cli.VagrantCli;
import vagrant.impl.cli.parser.AllStatusParser;
import vagrant.impl.cli.parser.SshConfigParser;
import vagrant.impl.cli.parser.StatusParser;
import vagrant.impl.cli.parser.VersionParser;

public class VagrantImpl
implements VagrantApi {
    private File path;
    private CommandIOListener ioListener;

    public VagrantImpl(File path) {
        this(path, null);
    }

    public VagrantImpl(File path, CommandIOListener ioListener) {
        this.path = path;
        this.ioListener = ioListener;
    }

    @Override
    public BoxApi box() {
        return new BoxImpl(this.path, this.ioListener);
    }

    @Override
    public String getVersion() {
        String out = this.vagrant().arg("version").machineReadable().execute();
        return new VersionParser().parse(out);
    }

    @Override
    public void init(String box) {
        this.path.mkdirs();
        this.vagrant().arg("init").arg(box).machineReadable().execute();
    }

    @Override
    public void up(String name) {
        this.vagrant().arg("up").arg(name).machineReadable().execute();
    }

    @Override
    public void up(String name, String provider) {
        VagrantCli cli = this.vagrant().arg("up");
        if (provider != null) {
            cli.arg("--provider");
            cli.arg(provider);
        }
        cli.arg(name).machineReadable().execute();
    }

    @Override
    public void destroy(String name) {
        this.vagrant().arg("destroy").arg(name).arg("--force").machineReadable().execute();
    }

    @Override
    public Collection<Machine> status() {
        String out = this.vagrant().arg("status").machineReadable().execute();
        return new AllStatusParser(this.path).parse(out);
    }

    @Override
    public Machine status(String name) {
        String out = this.vagrant().arg("status").arg(name).machineReadable().execute();
        return new StatusParser(this.path).parse(out);
    }

    @Override
    public void halt(String name) {
        this.vagrant().arg("halt").arg(name).machineReadable().execute();
    }

    @Override
    public void haltForced(String name) {
        this.vagrant().arg("halt").arg(name).arg("--force").machineReadable().execute();
    }

    @Override
    public void reload(String name) {
        this.vagrant().arg("reload").arg(name).machineReadable().execute();
    }

    @Override
    public void resume(String name) {
        this.vagrant().arg("resume").arg(name).machineReadable().execute();
    }

    @Override
    public void suspend(String name) {
        this.vagrant().arg("suspend").arg(name).machineReadable().execute();
    }

    @Override
    public SshConfig sshConfig(String name) {
        String out = this.vagrant().arg("ssh-config").arg(name).machineReadable().execute();
        return (SshConfig)new SshConfigParser().parse(out).get(name);
    }

    @Override
    public boolean exists() {
        return this.path.exists() && new File(this.path, "Vagrantfile").exists();
    }

    @Override
    public File getPath() {
        return this.path;
    }

    @Override
    public String ssh(String name, String command) {
        return this.vagrant().arg("ssh").arg(name).arg("-c").arg(command).execute();
    }

    private VagrantCli vagrant() {
        return new VagrantCli(this.path, this.ioListener);
    }
}

