/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.dev.moskito.core.predefined.CacheStats;
import net.java.dev.moskito.core.predefined.Constants;
import net.java.dev.moskito.core.producers.IStats;
import net.java.dev.moskito.core.producers.IStatsProducer;
import net.java.dev.moskito.core.registry.IProducerRegistry;
import net.java.dev.moskito.core.registry.ProducerRegistryFactory;

public abstract class AbstractCache
implements IStatsProducer {
    private List<IStats> stats;
    private CacheStats cacheStats;
    private String name;
    private static final AtomicInteger instanceCounter = new AtomicInteger(0);

    protected AbstractCache(String aName) {
        this.name = aName;
        this.stats = new ArrayList<IStats>();
        this.cacheStats = new CacheStats(this.name, Constants.getDefaultIntervals());
        this.stats.add((IStats)this.cacheStats);
        IProducerRegistry reg = ProducerRegistryFactory.getProducerRegistryInstance();
        if (reg.getProducer(this.name) == null) {
            reg.registerProducer((IStatsProducer)this);
        } else {
            String myName = null;
            while (reg.getProducer(myName = this.name + "-" + instanceCounter.incrementAndGet()) != null) {
            }
            this.name = myName;
            reg.registerProducer((IStatsProducer)this);
        }
    }

    protected static String getUnnamedInstanceName(Class<?> that) {
        return that.getSimpleName() + "-" + instanceCounter.incrementAndGet();
    }

    public String getCategory() {
        return "cache";
    }

    public String getProducerId() {
        return this.getName();
    }

    public List<IStats> getStats() {
        return this.stats;
    }

    public String getSubsystem() {
        return "default";
    }

    public CacheStats getCacheStats() {
        return this.cacheStats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

