/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import net.anotheria.anoprise.cache.AbstractCache;
import net.anotheria.anoprise.cache.BoundedCache;
import net.java.dev.moskito.core.predefined.CacheStats;

public class BoundedHardwiredCache<K, V>
extends AbstractCache
implements BoundedCache<K, V> {
    public static final int DEF_MAX_SIZE = 3000;
    private ConcurrentHashMap<K, V> cache;
    private Semaphore lock;
    private int maxSize;
    private CacheStats cacheStatsCopy = null;

    public BoundedHardwiredCache() {
        this(BoundedHardwiredCache.getUnnamedInstanceName(BoundedHardwiredCache.class));
    }

    public BoundedHardwiredCache(int aMaxSize) {
        this(BoundedHardwiredCache.getUnnamedInstanceName(BoundedHardwiredCache.class), aMaxSize);
    }

    public BoundedHardwiredCache(String name) {
        this(name, 3000);
    }

    public BoundedHardwiredCache(String name, int aMaxSize) {
        super(name);
        this.maxSize = aMaxSize;
        this.cacheStatsCopy = this.getCacheStats();
        this.init();
    }

    @Override
    public void remove(K id) {
        this.cacheStatsCopy.addDelete();
        V old = this.cache.remove(id);
        if (old != null) {
            this.lock.release();
        }
    }

    @Override
    public V get(K id) {
        this.cacheStatsCopy.addRequest();
        V ret = this.cache.get(id);
        if (ret != null) {
            this.cacheStatsCopy.addHit();
        }
        return ret;
    }

    @Override
    public boolean offer(K id, V cacheable) {
        this.cacheStatsCopy.addWrite();
        if (!this.lock.tryAcquire()) {
            this.cacheStatsCopy.addCacheFull();
            return false;
        }
        V old = this.cache.put(id, cacheable);
        if (old != null) {
            this.lock.release();
        }
        return true;
    }

    private void init() {
        this.clear();
    }

    @Override
    public synchronized void clear() {
        this.cache = new ConcurrentHashMap(this.maxSize);
        this.lock = new Semaphore(this.maxSize);
    }

    public String toString() {
        if (this.cache == null) {
            return this.getName() + " - not initialized.";
        }
        String ret = this.getName() + " ";
        ret = ret + " MaxSize: " + this.maxSize + ", remaining elements: " + this.lock.availablePermits() + ", realSize: " + this.cache.size();
        return ret;
    }
}

