/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.CacheController;
import net.anotheria.anoprise.cache.CacheProducerWrapper;
import net.anotheria.anoprise.cache.ExpiringCache;
import net.anotheria.anoprise.cache.FailoverCache;
import net.anotheria.anoprise.cache.ModableTypeHandler;
import net.anotheria.anoprise.cache.RoundRobinHardwiredCache;
import net.anotheria.anoprise.cache.RoundRobinHardwiredCacheFactory;
import net.anotheria.anoprise.cache.RoundRobinSoftReferenceCache;
import net.anotheria.anoprise.cache.RoundRobinSoftReferenceCacheFactory;
import net.java.dev.moskito.core.logging.DefaultStatsLogger;
import net.java.dev.moskito.core.logging.ILogOutput;
import net.java.dev.moskito.core.logging.IntervalStatsLogger;
import net.java.dev.moskito.core.logging.Log4JOutput;
import net.java.dev.moskito.core.producers.IStatsProducer;
import net.java.dev.moskito.core.stats.DefaultIntervals;
import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;

public final class Caches {
    public static <K, V> Cache<K, V> createSoftReferenceCache(String name) {
        return new RoundRobinSoftReferenceCache(name);
    }

    public static <K, V> Cache<K, V> createSoftReferenceCache(String name, int startSize, int maxSize) {
        return new RoundRobinSoftReferenceCache(name, startSize, maxSize);
    }

    public static <K, V> Cache<K, V> createHardwiredCache(String name) {
        return new RoundRobinHardwiredCache(name);
    }

    public static <K, V> Cache<K, V> createHardwiredCache(String name, int startSize, int maxSize) {
        return new RoundRobinHardwiredCache(name, startSize, maxSize);
    }

    public static <K, V> Cache<K, V> createHardwiredExpiringCache(String name, int startSize, int maxSize, int expirationTime) {
        Cache<K, V> underlyingCache = Caches.createHardwiredCache(name, startSize, maxSize);
        return new ExpiringCache(name, expirationTime, underlyingCache);
    }

    public static <K, V> Cache<K, V> createSoftReferenceExpiringCache(String name, int startSize, int maxSize, int expirationTime) {
        Cache<K, V> underlyingCache = Caches.createSoftReferenceCache(name, startSize, maxSize);
        return new ExpiringCache(name, expirationTime, underlyingCache);
    }

    public static <K, V> Cache<K, V> createConfigurableSoftReferenceCache(String name) {
        RoundRobinSoftReferenceCacheFactory factory = new RoundRobinSoftReferenceCacheFactory();
        CacheController controller = new CacheController(name, factory);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static <K, V> Cache<K, V> createConfigurableSoftReferenceExpiringCache(String name) {
        RoundRobinSoftReferenceCacheFactory factory = new RoundRobinSoftReferenceCacheFactory();
        CacheController controller = new CacheController(name, factory);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static <K, V> Cache<K, V> createConfigurableHardwiredCache(String name) {
        RoundRobinHardwiredCacheFactory factory = new RoundRobinHardwiredCacheFactory();
        CacheController controller = new CacheController(name, factory);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static <K, V> Cache<K, V> createConfigurableCache(String name) {
        CacheController controller = new CacheController(name);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static <K, V> Cache<K, V> createSoftReferenceFailoverSupportCache(String name, int startSize, int maxSize, int instanceAmount, int currentInstanceNumber, ModableTypeHandler modableTypeHandler) {
        Cache<K, V> underlyingCache = Caches.createSoftReferenceCache(name, startSize, maxSize);
        return new FailoverCache<K, V>(name, instanceAmount, currentInstanceNumber, modableTypeHandler, underlyingCache);
    }

    public static <K, V> Cache<K, V> createSoftReferenceExpiringFailoverSupportCache(String name, int startSize, int maxSize, int expirationTime, int instanceAmount, int currentInstanceNumber, ModableTypeHandler modableTypeHandler) {
        Cache<K, V> underlyingCache = Caches.createSoftReferenceExpiringCache(name, startSize, maxSize, expirationTime);
        return new FailoverCache<K, V>(name, instanceAmount, currentInstanceNumber, modableTypeHandler, underlyingCache);
    }

    public static <K, V> Cache<K, V> createConfigurableSoftReferenceCacheFailoverSupportCache(String name, int instanceAmount, int currentInstanceNumber, ModableTypeHandler modableTypeHandler) {
        RoundRobinSoftReferenceCacheFactory factory = new RoundRobinSoftReferenceCacheFactory();
        CacheController controller = new CacheController(name, factory, instanceAmount, currentInstanceNumber, modableTypeHandler);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static <K, V> Cache<K, V> createConfigurableSoftReferenceExpiringCacheFailoverSupportCache(String name, int instanceAmount, int currentInstanceNumber, ModableTypeHandler modableTypeHandler) {
        RoundRobinSoftReferenceCacheFactory factory = new RoundRobinSoftReferenceCacheFactory();
        CacheController controller = new CacheController(name, factory, instanceAmount, currentInstanceNumber, modableTypeHandler);
        ConfigurationManager.INSTANCE.configureAs(controller, name);
        return controller;
    }

    public static void attachCacheToMoskitoLoggers(Cache<?, ?> cache, String producerId, String category, String subsystem) {
        CacheProducerWrapper cacheWrapper = new CacheProducerWrapper(cache, producerId, category, subsystem);
        new DefaultStatsLogger((IStatsProducer)cacheWrapper, (ILogOutput)new Log4JOutput(Logger.getLogger((String)"moskito.custom.default")));
        new IntervalStatsLogger((IStatsProducer)cacheWrapper, DefaultIntervals.FIVE_MINUTES, (ILogOutput)new Log4JOutput(Logger.getLogger((String)"moskito.custom.5m")));
        new IntervalStatsLogger((IStatsProducer)cacheWrapper, DefaultIntervals.FIFTEEN_MINUTES, (ILogOutput)new Log4JOutput(Logger.getLogger((String)"moskito.custom.15m")));
        new IntervalStatsLogger((IStatsProducer)cacheWrapper, DefaultIntervals.ONE_HOUR, (ILogOutput)new Log4JOutput(Logger.getLogger((String)"moskito.custom.1h")));
        new IntervalStatsLogger((IStatsProducer)cacheWrapper, DefaultIntervals.ONE_DAY, (ILogOutput)new Log4JOutput(Logger.getLogger((String)"moskito.custom.1d")));
    }

    private Caches() {
    }

    public static enum Wiring {
        HARDWIRED,
        SOFTREFERENCE;

    }

    public static enum Strategy {
        ROUNDROBIN,
        EXPIRATION;

    }
}

