/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.CacheFactory;
import net.anotheria.anoprise.cache.DefaultModableTypeHandler;
import net.anotheria.anoprise.cache.ModableTypeHandler;
import net.java.dev.moskito.core.predefined.CacheStats;

public class FailoverCache<K, V>
implements Cache<K, V> {
    private Cache<K, V> cache;
    private int instanceAmount;
    private int currentInstanceNumber;
    private ModableTypeHandler modableTypeHandler;
    private CacheStats moskitoCacheStats;

    public FailoverCache(String name, int aStartSize, int aMaxSize, int aInstanceAmount, int aCurrentInstanceNumber, ModableTypeHandler aModableTypeHandler, CacheFactory<K, V> underlyingCacheFactory) {
        this(name, aInstanceAmount, aCurrentInstanceNumber, aModableTypeHandler, underlyingCacheFactory.create(name, aStartSize, aMaxSize));
    }

    public FailoverCache(String name, int aInstanceAmount, int aCurrentInstanceNumber, ModableTypeHandler aModableTypeHandler, Cache<K, V> underlyingCache) {
        this.cache = underlyingCache;
        this.instanceAmount = aInstanceAmount > 0 ? aInstanceAmount : 1;
        this.currentInstanceNumber = aCurrentInstanceNumber;
        this.modableTypeHandler = aModableTypeHandler != null ? aModableTypeHandler : new DefaultModableTypeHandler();
        this.moskitoCacheStats = this.cache.getCacheStats();
    }

    @Override
    public V get(K id) {
        if (this.isFailOverCall(id)) {
            return null;
        }
        return this.cache.get(id);
    }

    @Override
    public void put(K id, V cacheable) {
        if (!this.isFailOverCall(id)) {
            this.cache.put(id, cacheable);
        }
    }

    public String toString() {
        return this.cache.toString() + ", instanceAmount=" + this.instanceAmount + ", currentInstanceNumber=" + this.currentInstanceNumber;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void remove(K id) {
        if (!this.isFailOverCall(id)) {
            this.cache.remove(id);
        }
    }

    @Override
    public CacheStats getCacheStats() {
        return this.moskitoCacheStats;
    }

    private boolean isFailOverCall(Object id) {
        if (this.instanceAmount < 2 || this.currentInstanceNumber < 0) {
            return false;
        }
        return (long)this.currentInstanceNumber != Math.abs(this.modableTypeHandler.getModableValue(id)) % (long)this.instanceAmount;
    }
}

