/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dataspace.persistence;

import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;

@ConfigureMe(name="ano-prise-dataspace-config")
public class DataspacePersistenceConfiguration {
    @DontConfigure
    private static final Logger LOGGER = Logger.getLogger((String)DataspacePersistenceConfiguration.class.getName());
    @DontConfigure
    public static final String SEPARATOR = ", ";
    @Configure
    private String tableName = "dataspace";
    @Configure
    private String dbOwnerName = "postgres";
    @Configure
    private String primaryKeyName = "dataspace_pk";
    @Configure
    private String fieldNameUserId = "userId";
    @Configure
    private String fieldNameDataspaceId = "dataspaceId";
    @Configure
    private String fieldNameAttributeName = "attrName";
    @Configure
    private String fieldNameAttributeTypeId = "attrTypeId";
    @Configure
    private String fieldNameAttributeValue = "attrValue";
    @Configure
    private String fieldNameUpdated = "updated";
    @DontConfigure
    private static DataspacePersistenceConfiguration INSTANCE;

    public static synchronized DataspacePersistenceConfiguration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataspacePersistenceConfiguration();
            try {
                ConfigurationManager.INSTANCE.configure((Object)INSTANCE);
            }
            catch (Exception e) {
                LOGGER.error((Object)"getInstance() Configuration failed. Configuring with defaults.", (Throwable)e);
            }
        }
        return INSTANCE;
    }

    public static DataspacePersistenceConfiguration getInstance(String configurationFileName) {
        DataspacePersistenceConfiguration configuration = new DataspacePersistenceConfiguration();
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)configuration, configurationFileName);
        }
        catch (Exception e) {
            LOGGER.error((Object)("getInstance(" + configurationFileName + ") Configuration failed. Configuring with defaults."), (Throwable)e);
        }
        return configuration;
    }

    public void setTableName(String aTableName) {
        this.tableName = aTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDbOwnerName() {
        return this.dbOwnerName;
    }

    public void setDbOwnerName(String aDbOwnerName) {
        this.dbOwnerName = aDbOwnerName;
    }

    public void setPrimaryKeyName(String aPrimaryKeyName) {
        this.primaryKeyName = aPrimaryKeyName;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setFieldNameUserId(String aFieldNameUserId) {
        this.fieldNameUserId = aFieldNameUserId;
    }

    public String getFieldNameUserId() {
        return this.fieldNameUserId;
    }

    public void setFieldNameDataspaceId(String aFieldNameDataspaceId) {
        this.fieldNameDataspaceId = aFieldNameDataspaceId;
    }

    public String getFieldNameDataspaceId() {
        return this.fieldNameDataspaceId;
    }

    public void setFieldNameAttributeName(String aFieldNameAttributeName) {
        this.fieldNameAttributeName = aFieldNameAttributeName;
    }

    public String getFieldNameAttributeName() {
        return this.fieldNameAttributeName;
    }

    public void setFieldNameAttributeTypeId(String aFieldNameAttributeTypeId) {
        this.fieldNameAttributeTypeId = aFieldNameAttributeTypeId;
    }

    public String getFieldNameAttributeTypeId() {
        return this.fieldNameAttributeTypeId;
    }

    public void setFieldNameAttributeValue(String aFieldNameAttributeValue) {
        this.fieldNameAttributeValue = aFieldNameAttributeValue;
    }

    public String getFieldNameAttributeValue() {
        return this.fieldNameAttributeValue;
    }

    public void setFieldNameUpdated(String aFieldNameUpdated) {
        this.fieldNameUpdated = aFieldNameUpdated;
    }

    public String getFieldNameUpdated() {
        return this.fieldNameUpdated;
    }

    public String getTableFields() {
        return this.getFieldNameUserId() + SEPARATOR + this.getFieldNameDataspaceId() + SEPARATOR + this.getFieldNameAttributeName() + SEPARATOR + this.getFieldNameAttributeTypeId() + SEPARATOR + this.getFieldNameAttributeValue() + SEPARATOR + this.getFieldNameUpdated();
    }

    public String getDDLCreateTable() {
        return "CREATE TABLE " + this.getTableName() + " (" + this.getFieldNameUserId() + " character varying NOT NULL, " + this.getFieldNameDataspaceId() + " integer NOT NULL, " + this.getFieldNameAttributeName() + " character varying NOT NULL, " + this.getFieldNameAttributeTypeId() + " integer NOT NULL, " + this.getFieldNameAttributeValue() + " character varying NOT NULL, " + this.getFieldNameUpdated() + " bigint NOT NULL, " + "CONSTRAINT " + this.getPrimaryKeyName() + " PRIMARY KEY (" + this.getFieldNameUserId() + SEPARATOR + this.getFieldNameDataspaceId() + SEPARATOR + this.getFieldNameAttributeName() + ")" + ");";
    }

    public String getDDLSetOwner() {
        return "GRANT ALL ON " + this.getTableName() + " TO " + this.getDbOwnerName() + ";";
    }

    public String getSQLGetDataspace() {
        return "SELECT " + this.getTableFields() + " FROM " + this.getTableName() + " WHERE " + this.getFieldNameUserId() + " = ?" + " AND " + this.getFieldNameDataspaceId() + "= ?;";
    }

    public String getSQLInsertAttribute() {
        return "INSERT INTO " + this.getTableName() + " (" + this.getTableFields() + ")" + " VALUES (?, ?, ?, ?, ?, ?);";
    }

    public String getSQLRemoveDataspace() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + this.getFieldNameUserId() + " = ?" + " AND " + this.getFieldNameDataspaceId() + " = ?;";
    }

    public String toString() {
        return "DataspacePersistenceConfiguration [tableName=" + this.tableName + ", dbOwnerName=" + this.dbOwnerName + ", primaryKeyName=" + this.primaryKeyName + ", fieldNameUserId=" + this.fieldNameUserId + ", fieldNameDataspaceId=" + this.fieldNameDataspaceId + ", fieldNameAttributeName=" + this.fieldNameAttributeName + ", fieldNameAttributeTypeId=" + this.fieldNameAttributeTypeId + ", fieldNameAttributeValue=" + this.fieldNameAttributeValue + ", fieldNameUpdated=" + this.fieldNameUpdated + "]";
    }
}

