/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dataspace.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.dataspace.Dataspace;
import net.anotheria.anoprise.dataspace.DataspaceType;
import net.anotheria.anoprise.dataspace.attribute.Attribute;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceConfiguration;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceService;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceServiceException;
import net.anotheria.db.service.GenericPersistenceService;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;
import org.apache.log4j.Logger;

public class DataspacePersistenceServiceImpl
extends GenericPersistenceService
implements DataspacePersistenceService {
    private final Logger log = Logger.getLogger(DataspacePersistenceServiceImpl.class);
    private static final String LOG_PREFIX = "DATASPACE PERSISTENCE SERVICE: ";
    private final List<String> ddlQueries = new ArrayList<String>();
    private final DataspacePersistenceConfiguration configuration;
    private IdBasedLockManager lockManager;

    protected DataspacePersistenceServiceImpl(DataspacePersistenceConfiguration aConfiguration) {
        if (aConfiguration == null) {
            throw new IllegalArgumentException("DataspacePersistenceServiceImpl(aConfiguration) fail. Null argument.");
        }
        this.configuration = aConfiguration;
        this.ddlQueries.add(this.configuration.getDDLCreateTable());
        this.ddlQueries.add(this.configuration.getDDLSetOwner());
        this.initialize();
        this.lockManager = new SafeIdBasedLockManager();
    }

    @Override
    public Dataspace loadDataspace(String userId, DataspaceType dataspaceType) throws DataspacePersistenceServiceException {
        if (userId == null) {
            throw new IllegalArgumentException("User id null");
        }
        if (dataspaceType == null) {
            throw new IllegalArgumentException("Dataspace type null");
        }
        Dataspace result = new Dataspace(userId, dataspaceType);
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            st = conn.prepareStatement(this.configuration.getSQLGetDataspace());
            st.setString(1, userId);
            st.setInt(2, dataspaceType.getId());
            rs = st.executeQuery();
            while (rs.next()) {
                int attrType = rs.getInt(this.configuration.getFieldNameAttributeTypeId());
                String attrName = rs.getString(this.configuration.getFieldNameAttributeName());
                String attrValue = rs.getString(this.configuration.getFieldNameAttributeValue());
                result.addAttribute(attrName, Attribute.createAttribute(attrType, attrName, attrValue));
            }
        }
        catch (SQLException sqle) {
            try {
                this.log.error((Object)("DATASPACE PERSISTENCE SERVICE: SQL Exception: " + sqle.getMessage()), (Throwable)sqle);
                throw new DataspacePersistenceServiceException(sqle.getMessage(), sqle);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(st);
                this.close(conn);
                throw throwable;
            }
        }
        this.close(rs);
        this.close(st);
        this.close(conn);
        return result;
    }

    @Override
    public void saveDataspace(Dataspace dataspace) throws DataspacePersistenceServiceException {
        if (dataspace == null) {
            throw new IllegalArgumentException("Dataspace null");
        }
        if (dataspace.getUserId() == null) {
            throw new IllegalArgumentException("User id null");
        }
        if (dataspace.getDataspaceType() == null) {
            throw new IllegalArgumentException("Dataspace type null");
        }
        Connection conn = null;
        PreparedStatement st = null;
        PreparedStatement st2 = null;
        String lockId = dataspace.getUserId() + "_" + dataspace.getDataspaceType();
        IdBasedLock lock = this.lockManager.obtainLock((Object)lockId);
        lock.lock();
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
            st = conn.prepareStatement(this.configuration.getSQLRemoveDataspace());
            st.setString(1, dataspace.getUserId());
            st.setInt(2, dataspace.getDataspaceType().getId());
            st.executeUpdate();
            st2 = conn.prepareStatement(this.configuration.getSQLInsertAttribute());
            if (conn.getMetaData().supportsBatchUpdates()) {
                for (Attribute attribute : dataspace.getAttributes()) {
                    st2.setString(1, dataspace.getUserId());
                    st2.setInt(2, dataspace.getDataspaceType().getId());
                    st2.setString(3, attribute.getName());
                    st2.setInt(4, attribute.getType().getTypeId());
                    st2.setString(5, attribute.getValueAsString());
                    st2.setLong(6, System.currentTimeMillis());
                    st2.addBatch();
                }
                st2.executeBatch();
            } else {
                for (Attribute attribute : dataspace.getAttributes()) {
                    st2.clearParameters();
                    st2.setString(1, dataspace.getUserId());
                    st2.setInt(2, dataspace.getDataspaceType().getId());
                    st2.setString(3, attribute.getName());
                    st2.setInt(4, attribute.getType().getTypeId());
                    st2.setString(5, attribute.getValueAsString());
                    st2.setLong(6, System.currentTimeMillis());
                    st2.executeUpdate();
                }
            }
            conn.commit();
        }
        catch (SQLException sqle) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException sqle2) {
                    this.log.error((Object)("DATASPACE PERSISTENCE SERVICE: SQL Exception on transaction rollback: " + sqle2.getMessage()), (Throwable)sqle2);
                }
                this.log.error((Object)("DATASPACE PERSISTENCE SERVICE: SQL Exception: " + sqle.getMessage()), (Throwable)sqle);
                throw new DataspacePersistenceServiceException(sqle.getMessage(), sqle);
            }
            catch (Throwable throwable) {
                this.close(st2);
                this.close(st);
                this.close(conn);
                lock.unlock();
                throw throwable;
            }
        }
        this.close(st2);
        this.close(st);
        this.close(conn);
        lock.unlock();
    }

    protected List<String> getDDL() {
        return this.ddlQueries;
    }

    protected String getTableName() {
        return this.configuration.getTableName();
    }

    protected String getPKFieldName() {
        return null;
    }
}

