/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dualcrud;

import net.anotheria.anoprise.dualcrud.CrudSaveable;
import net.anotheria.anoprise.dualcrud.CrudService;
import net.anotheria.anoprise.dualcrud.CrudServiceException;
import net.anotheria.anoprise.dualcrud.DualCrudConfig;
import net.anotheria.anoprise.dualcrud.DualCrudService;
import net.anotheria.anoprise.dualcrud.ItemNotFoundException;
import net.anotheria.anoprise.dualcrud.Query;
import net.anotheria.anoprise.dualcrud.QueryResult;
import org.apache.log4j.Logger;

public class DualCrudServiceImpl<T extends CrudSaveable>
implements DualCrudService<T> {
    private CrudService<T> left;
    private CrudService<T> right;
    private DualCrudConfig config;
    private static Logger log = Logger.getLogger(DualCrudServiceImpl.class);

    protected DualCrudServiceImpl(DualCrudConfig aConfig, CrudService<T> aLeft, CrudService<T> aRight) {
        this.config = aConfig;
        this.left = aLeft;
        this.right = aRight;
    }

    @Override
    public T create(T t) throws CrudServiceException {
        T result = null;
        CrudService<T> primary = this.config.getPrimaryWriter(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryWriter(this.left, this.right);
        result = primary.create(t);
        if (this.config.writeToBoth() && secondary != primary) {
            secondary.create(t);
        }
        return result;
    }

    @Override
    public void delete(T t) throws CrudServiceException {
        CrudService<T> primary = this.config.getPrimaryWriter(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryWriter(this.left, this.right);
        primary.delete(t);
        if (primary != secondary) {
            try {
                secondary.delete(t);
            }
            catch (CrudServiceException e) {
                log.warn((Object)("delete on secondary writer failed, ignored, delete(" + t + ")"), (Throwable)e);
            }
        }
    }

    @Override
    public void migrate(String ownerId) throws CrudServiceException {
        CrudService<T> secondaryWriter;
        CrudService<T> primaryWriter = this.config.getPrimaryWriter(this.left, this.right);
        if (primaryWriter == (secondaryWriter = this.config.getSecondaryWriter(this.left, this.right))) {
            throw new CrudServiceException("Noop migration request");
        }
        T t = secondaryWriter.read(ownerId);
        primaryWriter.save(t);
        try {
            secondaryWriter.delete(t);
        }
        catch (CrudServiceException e) {
            log.warn((Object)("delete on secondary writer failed, ignored, migrate(" + t + ")"), (Throwable)e);
        }
    }

    @Override
    public T read(String ownerId) throws CrudServiceException {
        CrudService<T> primary = this.config.getPrimaryReader(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryReader(this.left, this.right);
        try {
            T t = primary.read(ownerId);
            return t;
        }
        catch (ItemNotFoundException e) {
            if (!this.config.readFromBoth()) {
                throw e;
            }
        }
        catch (CrudServiceException e) {
            throw e;
        }
        T fromSecondary = secondary.read(ownerId);
        if (this.config.migrateOnRead()) {
            try {
                primary.create(fromSecondary);
                if (this.config.deleteUponMigration()) {
                    secondary.delete(fromSecondary);
                }
            }
            catch (CrudServiceException e) {
                log.warn((Object)("migrate on the fly failed, ignored, read(" + ownerId + ")"), (Throwable)e);
            }
        }
        return fromSecondary;
    }

    @Override
    public T save(T t) throws CrudServiceException {
        T result = null;
        CrudService<T> primary = this.config.getPrimaryWriter(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryWriter(this.left, this.right);
        result = primary.save(t);
        if (this.config.migrateOnWrite()) {
            try {
                secondary.delete(t);
            }
            catch (CrudServiceException e) {
                log.warn((Object)("delete on secondary writer failed, ignored, save(" + t + ")"), (Throwable)e);
            }
        }
        if (this.config.writeToBoth()) {
            secondary.save(t);
        }
        return result;
    }

    @Override
    public T update(T t) throws CrudServiceException {
        T result = null;
        CrudService<T> primary = this.config.getPrimaryWriter(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryWriter(this.left, this.right);
        if (primary.exists(t)) {
            result = primary.update(t);
            if (this.config.migrateOnWrite()) {
                try {
                    secondary.delete(t);
                }
                catch (CrudServiceException e) {
                    log.warn((Object)("delete on secondary writer failed, ignored, update(" + t + ")"), (Throwable)e);
                }
            }
            if (this.config.writeToBoth()) {
                secondary.update(t);
            }
            return result;
        }
        if (secondary.exists(t)) {
            if (!this.config.migrateOnWrite()) {
                return secondary.update(t);
            }
            result = primary.create(t);
            try {
                secondary.delete(t);
            }
            catch (CrudServiceException e) {
                log.warn((Object)("delete on secondary writer failed, ignored, save(" + t + ")"), (Throwable)e);
            }
            return result;
        }
        throw new ItemNotFoundException(t.getOwnerId());
    }

    @Override
    public boolean exists(T t) throws CrudServiceException {
        CrudService<T> primary = this.config.getPrimaryReader(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryReader(this.left, this.right);
        if (primary.exists(t)) {
            return true;
        }
        return secondary != primary && secondary.exists(t);
    }

    @Override
    public QueryResult<T> query(Query q) throws CrudServiceException {
        CrudService<T> primary = this.config.getPrimaryReader(this.left, this.right);
        CrudService<T> secondary = this.config.getSecondaryReader(this.left, this.right);
        return new QueryResult<T>(primary.query(q), secondary.query(q));
    }
}

