/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.eventservice;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoprise.eventservice.AbstractEventChannel;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.EventServiceConsumer;
import net.anotheria.anoprise.eventservice.EventServicePushConsumer;

public class EventChannelPushConsumerProxy
extends AbstractEventChannel
implements EventChannelConsumerProxy {
    private List<EventServiceConsumer> consumers = new ArrayList<EventServiceConsumer>(10);

    public EventChannelPushConsumerProxy(String name) {
        super(name);
    }

    @Override
    public void addConsumer(EventServiceConsumer consumer) {
        if (!(consumer instanceof EventServicePushConsumer)) {
            throw new IllegalArgumentException("Only EventServicePushConsumer are supported.");
        }
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(EventServiceConsumer consumer) {
        this.consumers.remove(consumer);
    }

    @Override
    public void pushEvent(Event e) {
        int n = this.consumers.size();
        for (int i = 0; i < n; ++i) {
            EventServicePushConsumer consumer = (EventServicePushConsumer)this.consumers.get(i);
            try {
                consumer.push(e);
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)("Pushing to consumer " + consumer + " caused an error:"), (Throwable)ex);
            }
        }
    }

    public String toString() {
        return "PushConsumerProxy " + this.getName();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void push(Event e) {
        throw new UnsupportedOperationException("push");
    }
}

