/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.eventservice;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoprise.eventservice.AbstractEventChannel;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.EventChannelSupplierProxy;
import net.anotheria.anoprise.eventservice.EventServiceConsumer;

public class EventChannelPushSupplierProxy
extends AbstractEventChannel
implements EventChannelSupplierProxy {
    private List<EventChannelConsumerProxy> consumerProxies = new CopyOnWriteArrayList<EventChannelConsumerProxy>();

    public EventChannelPushSupplierProxy(String name) {
        super(name);
    }

    @Override
    public void addConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("addConsumer");
    }

    @Override
    public void push(Event e) {
        this.push(e, false);
    }

    protected void push(Event e, boolean localOnly) {
        for (EventChannelConsumerProxy proxy : this.consumerProxies) {
            if (localOnly && !proxy.isLocal()) {
                this.log.debug((Object)("Skiping proxy: " + proxy));
                continue;
            }
            try {
                proxy.pushEvent(e);
            }
            catch (Exception ex) {
                this.log.error((Object)("pushEvent(" + e + ")"), (Throwable)ex);
            }
        }
    }

    @Override
    public void removeConsumer(EventServiceConsumer consumer) {
        throw new UnsupportedOperationException("removeConsumer");
    }

    @Override
    public void addConsumerProxy(EventChannelConsumerProxy proxy) {
        this.out("Added consumer proxy: " + proxy);
        this.consumerProxies.add(proxy);
    }

    @Override
    public void removeConsumerProxy(EventChannelConsumerProxy proxy) {
        this.consumerProxies.remove(proxy);
    }

    public String toString() {
        return "PushSupplierProxy " + this.getName() + ", connected to:" + this.consumerProxies;
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

