/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.eventservice.util;

import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventServicePushConsumer;
import net.anotheria.anoprise.eventservice.util.QueuedEventSender;
import net.anotheria.util.queue.IQueue;
import net.anotheria.util.queue.QueueOverflowException;
import net.anotheria.util.queue.StandardQueueFactory;
import org.apache.log4j.Logger;

public class QueuedEventReceiver
extends Thread
implements EventServicePushConsumer {
    private static final Logger DEFAULT_LOGGER = Logger.getLogger((String)QueuedEventReceiver.class.getName());
    private Logger logger;
    public static final int DEF_QUEUE_SIZE = 1000;
    private int queueSize;
    public static final long DEF_SLEEP_TIME = 50L;
    private long sleepTime;
    private String name;
    private String channelName;
    private int receivedCount;
    private int overflowCount;
    private int throwAwayCount;
    private IQueue<Event> queue;
    private EventServicePushConsumer eventConsumer;

    public QueuedEventReceiver(String aName, String aChannelName, EventServicePushConsumer aEventConsumer) {
        this(aName, aChannelName, aEventConsumer, 1000, 50L);
    }

    public QueuedEventReceiver(String aName, String aChannelName, EventServicePushConsumer aEventConsumer, int aQueueSize, long aSleepTime) {
        this(aName, aChannelName, aEventConsumer, aQueueSize, aSleepTime, DEFAULT_LOGGER);
    }

    public QueuedEventReceiver(String aName, String aChannelName, EventServicePushConsumer aEventConsumer, int aQueueSize, long aSleepTime, Logger aLogger) {
        super(aName);
        this.setDaemon(true);
        if (aName == null) {
            throw new IllegalArgumentException("Receiver name must be not null");
        }
        if (aChannelName == null) {
            throw new IllegalArgumentException("Event channel name must be not null");
        }
        if (aEventConsumer == null) {
            throw new IllegalArgumentException("Event consumer name must be not null");
        }
        if (aLogger == null) {
            throw new IllegalArgumentException("Logger must be not null");
        }
        this.name = aName;
        this.channelName = aChannelName;
        this.eventConsumer = aEventConsumer;
        this.queueSize = aQueueSize;
        this.sleepTime = aSleepTime;
        this.logger = aLogger;
        this.queue = new StandardQueueFactory().createQueue(this.queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Event event) {
        try {
            this.queue.putElement((Object)event);
        }
        catch (QueueOverflowException e1) {
            ++this.overflowCount;
            QueuedEventReceiver queuedEventReceiver = this;
            synchronized (queuedEventReceiver) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.queue.putElement((Object)event);
            }
            catch (QueueOverflowException e2) {
                ++this.throwAwayCount;
                this.logger.error((Object)("Couldn't recover from queue overflow, throwing away " + event));
            }
        }
    }

    @Override
    public void run() {
        try {
            this.receivedCount = 0;
            while (true) {
                if (this.queue.hasElements()) {
                    ++this.receivedCount;
                    if (this.receivedCount / 100 * 100 == this.receivedCount) {
                        this.logOutInfo();
                    }
                    try {
                        Event event = (Event)this.queue.nextElement();
                        if (event == null) {
                            this.logger.error((Object)"Event is NULL.");
                            continue;
                        }
                        this.eventConsumer.push(event);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Delivering event to consumer fail.", (Throwable)e);
                    }
                    continue;
                }
                try {
                    QueuedEventReceiver.sleep(this.sleepTime);
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (Throwable throwable) {
            try {
                this.logger.error((Object)"run() ", throwable);
            }
            catch (Exception e) {
                System.out.println(QueuedEventSender.class + " Can't log.");
                throwable.printStackTrace();
            }
            return;
        }
    }

    public int getOverflowCount() {
        return this.overflowCount;
    }

    public int getThrowAwayCount() {
        return this.throwAwayCount;
    }

    public String getStatsString() {
        return "EventsReceived:" + this.receivedCount + ", Queue: " + this.queue.toString() + ", OC:" + this.overflowCount + ", TAC:" + this.throwAwayCount;
    }

    public void logOutInfo() {
        this.logger.info((Object)("ReceiverName:" + this.name + ", ChannelName:" + this.channelName + ", Stats[" + this.getStatsString() + "]"));
    }

    public boolean hasUnsentElements() {
        return this.queue.hasElements();
    }
}

