/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.eventservice.util;

import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannel;
import net.anotheria.anoprise.eventservice.EventServiceFactory;
import net.anotheria.anoprise.eventservice.ProxyType;
import net.anotheria.anoprise.eventservice.util.QueueFullException;
import net.anotheria.util.queue.IQueue;
import net.anotheria.util.queue.QueueOverflowException;
import net.anotheria.util.queue.StandardQueueFactory;
import org.apache.log4j.Logger;

public class QueuedEventSender
extends Thread {
    private int counter;
    private String name;
    private Logger log;
    private static Logger defLogger = Logger.getLogger(QueuedEventSender.class);
    private IQueue<Event> queue;
    private EventChannel myChannel;
    public static final long DEF_SLEEP_TIME = 50L;
    public static final int DEF_QUEUE_SIZE = 1000;
    private long sleepTime;
    private int overflowCount;
    private int throwAwayCount;
    private volatile boolean started = false;
    private volatile boolean synchedMode = false;

    public QueuedEventSender(String aName, EventChannel aChannel, int queueSize, long aSleepTime, Logger aLog) {
        super(aName);
        this.setDaemon(true);
        this.name = aName;
        this.myChannel = aChannel;
        this.queue = new StandardQueueFactory().createQueue(queueSize);
        this.log = aLog;
        if (this.log == null) {
            defLogger.warn((Object)"Tried to assign null logger, switching to defLogger");
            this.log = defLogger;
        }
        this.sleepTime = aSleepTime;
    }

    public QueuedEventSender(String aName, String channelName, int queueSize, long aSleepTime, Logger aLog) {
        this(aName, EventServiceFactory.createEventService().obtainEventChannel(channelName, ProxyType.PUSH_SUPPLIER_PROXY), queueSize, aSleepTime, aLog);
    }

    public QueuedEventSender(String name, EventChannel channel, Logger log) {
        this(name, channel, 1000, 50L, log);
    }

    public QueuedEventSender(String name, String channelName, Logger log) {
        this(name, channelName, 1000, 50L, log);
    }

    public QueuedEventSender(String name, EventChannel channel) {
        this(name, channel, defLogger);
    }

    public QueuedEventSender(String name, String channelName) {
        this(name, channelName, defLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Event event) throws QueueFullException {
        if (this.synchedMode) {
            this.myChannel.push(event);
            return;
        }
        if (!this.started) {
            throw new IllegalStateException("Can't push into not started event sender");
        }
        try {
            this.queue.putElement((Object)event);
        }
        catch (QueueOverflowException e1) {
            ++this.overflowCount;
            QueuedEventSender queuedEventSender = this;
            synchronized (queuedEventSender) {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.queue.putElement((Object)event);
            }
            catch (QueueOverflowException e2) {
                ++this.throwAwayCount;
                this.log.error((Object)("couldn't recover from queue overflow, throwing away " + event));
                throw new QueueFullException(event, "Stats:" + this.getStatsString());
            }
        }
    }

    @Override
    public void start() {
        this.started = true;
        super.start();
    }

    @Override
    public void run() {
        try {
            this.counter = 0;
            while (true) {
                if (this.queue.hasElements()) {
                    ++this.counter;
                    if (this.counter / 100 * 100 == this.counter) {
                        this.logOutInfo();
                    }
                    try {
                        Event event = (Event)this.queue.nextElement();
                        if (event == null) {
                            this.log.error((Object)"Event to send is NULL, skipped.");
                            continue;
                        }
                        this.myChannel.push(event);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"myChannel.push", (Throwable)e);
                    }
                    continue;
                }
                try {
                    QueuedEventSender.sleep(50L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (Throwable ttt) {
            try {
                this.log.error((Object)"run ", ttt);
            }
            catch (Exception e) {
                System.out.println(QueuedEventSender.class + " Can't log!!!");
                ttt.printStackTrace();
            }
            return;
        }
    }

    public int getOverflowCount() {
        return this.overflowCount;
    }

    public int getThrowAwayCount() {
        return this.throwAwayCount;
    }

    public String getStatsString() {
        return this.counter + " elements sent, queue: " + this.queue.toString() + ", OC:" + this.overflowCount + ", TAC:" + this.throwAwayCount;
    }

    public void logOutInfo() {
        this.log.info((Object)(this.name + ": " + this.counter + " elements done, stat: " + this.queue.toString() + ", OC:" + this.overflowCount + ", TAC:" + this.throwAwayCount));
    }

    public boolean hasUnsentElements() {
        return this.queue.hasElements();
    }

    public boolean isSynchedMode() {
        return this.synchedMode;
    }

    public void setSynchedMode(boolean synchedMode) {
        this.synchedMode = synchedMode;
    }
}

