/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.fs;

import java.io.File;
import java.io.Serializable;
import net.anotheria.anoprise.fs.FSServiceConfigException;

public final class FSServiceConfig
implements Serializable {
    private static final long serialVersionUID = -2629878661534470687L;
    public static final String DEFAULT_FILE_EXTENSION = "dat";
    public static final int DEFAULT_MAX_OWNER_ID_LENGTH = 10;
    public static final int DEFAULT_FRAGMENT_LENGTH = 2;
    public static final String VALIDATION_ERROR_PREFIX = "Validation error: ";
    private String rootFolderPath;
    private String fileExtension;
    private int maxOwnerIdLength;
    private int fragmetLegth;

    public FSServiceConfig(String aRootFolderPath) throws FSServiceConfigException {
        this(aRootFolderPath, DEFAULT_FILE_EXTENSION, 10, 2);
    }

    public FSServiceConfig(String aRootFolderPath, String aFileExtension) throws FSServiceConfigException {
        this(aRootFolderPath, aFileExtension, 10, 2);
    }

    public FSServiceConfig(String aRootFolderPath, String aFileExtension, int aMaxOwnerIdLength, int aFragmentLength) throws FSServiceConfigException {
        this.rootFolderPath = FSServiceConfig.validateRootFilderPath(aRootFolderPath);
        this.fileExtension = FSServiceConfig.validateFileExtension(aFileExtension);
        this.maxOwnerIdLength = aMaxOwnerIdLength;
        this.fragmetLegth = aFragmentLength;
    }

    public String getRootFolderPath() {
        return this.rootFolderPath;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public static String getStoreFileName(String ownerId, String aFileExtension) throws FSServiceConfigException {
        return FSServiceConfig.validateOwnerId(ownerId) + "." + aFileExtension;
    }

    public String getStoreFileName(String ownerId) throws FSServiceConfigException {
        return FSServiceConfig.getStoreFileName(ownerId, this.fileExtension);
    }

    private static String[] fragmentOwnerId(String ownerId, int maxOwnerIdLength, int fragmentLength) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("OwnerId is null or empty");
        }
        while (ownerId.length() < maxOwnerIdLength) {
            ownerId = "0" + ownerId;
        }
        while (ownerId.length() % fragmentLength != 0) {
            ownerId = "0" + ownerId;
        }
        int fragmentationDepth = ownerId.length() / fragmentLength;
        String[] ret = new String[fragmentationDepth - 1];
        for (int i = 0; i < fragmentationDepth - 1; ++i) {
            String fragment;
            ret[i] = fragment = ownerId.substring(i * fragmentLength, i * fragmentLength + fragmentLength);
        }
        return ret;
    }

    public static String getStoreFolderPath(String ownerId, int maxOwnerIdLength, int fragmentLength) throws FSServiceConfigException {
        String id = FSServiceConfig.validateOwnerId(ownerId);
        String[] fragments = FSServiceConfig.fragmentOwnerId(id, maxOwnerIdLength, fragmentLength);
        StringBuilder ret = new StringBuilder();
        for (String f : fragments) {
            ret.append(f).append(File.separatorChar);
        }
        return ret.toString();
    }

    public String getStoreFolderPath(String ownerId) throws FSServiceConfigException {
        String path = this.rootFolderPath;
        String lastChar = path.substring(path.length() - 1, path.length());
        if (!lastChar.equals(File.separator)) {
            path = path + File.separator;
        }
        return path + FSServiceConfig.getStoreFolderPath(ownerId, this.maxOwnerIdLength, this.fragmetLegth);
    }

    public static String getStoreFilePath(String ownerId, int maxOwnerIdLength, int fragmentLength, String aFileExtension) throws FSServiceConfigException {
        return FSServiceConfig.getStoreFolderPath(ownerId, maxOwnerIdLength, fragmentLength) + FSServiceConfig.getStoreFileName(ownerId, aFileExtension);
    }

    public String getStoreFilePath(String ownerId) throws FSServiceConfigException {
        return this.getStoreFolderPath(ownerId) + this.getStoreFileName(ownerId);
    }

    private static String validateOwnerId(String ownerId) throws FSServiceConfigException {
        if (ownerId == null) {
            throw new FSServiceConfigException("Validation error: Null ownerId argument.");
        }
        if (ownerId.length() < 1) {
            throw new FSServiceConfigException("Validation error: Minimum length for ownerId: 1.");
        }
        try {
            return Integer.valueOf(ownerId).toString();
        }
        catch (NumberFormatException nfe) {
            throw new FSServiceConfigException("Validation error: NumberFormatException on parsing ownerId argument: " + nfe.getMessage());
        }
    }

    private static String validateRootFilderPath(String aRootFolderPath) throws FSServiceConfigException {
        if (aRootFolderPath == null) {
            throw new FSServiceConfigException("Validation error: Null aRootFolderPath argument.");
        }
        return aRootFolderPath;
    }

    private static String validateFileExtension(String aFileExtension) throws FSServiceConfigException {
        if (aFileExtension == null) {
            throw new FSServiceConfigException("Validation error: Null aServiceName argument.");
        }
        return aFileExtension;
    }
}

