/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.anotheria.anoprise.fs.FSItemNotFoundException;
import net.anotheria.anoprise.fs.FSSaveable;
import net.anotheria.anoprise.fs.FSService;
import net.anotheria.anoprise.fs.FSServiceConfig;
import net.anotheria.anoprise.fs.FSServiceException;
import net.anotheria.util.IOUtils;
import org.apache.log4j.Logger;

public class FSServiceImpl<T extends FSSaveable>
implements FSService<T> {
    private final FSServiceConfig config;
    private static Logger log = Logger.getLogger((String)FSServiceImpl.class.getName());
    private static final String SERVICE_LOG_PREFIX = "FS_SERVICE: ";

    public FSServiceImpl(FSServiceConfig aConfig) {
        this.config = aConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(String ownerId) throws FSServiceException {
        FSSaveable fSSaveable;
        String filePath = this.config.getStoreFilePath(ownerId);
        File file = new File(filePath);
        if (!file.exists()) {
            log.debug((Object)("FS_SERVICE: Item not found. Owner id: " + ownerId + ". File path: " + filePath));
            throw new FSItemNotFoundException(ownerId);
        }
        ObjectInputStream in = null;
        try {
            FSServiceImpl fSServiceImpl = this;
            synchronized (fSServiceImpl) {
                FSSaveable result;
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                fSSaveable = result = (FSSaveable)in.readObject();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIgnoringException(in);
            throw throwable;
        }
        {
            catch (IOException ioe) {
                log.error((Object)("FS_SERVICE: IOException: " + ioe.getMessage()));
                throw new FSServiceException(ioe.getMessage(), ioe);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("FS_SERVICE: ClassNotFoundException: " + cnfe.getMessage()));
                throw new FSServiceException(cnfe.getMessage(), cnfe);
            }
        }
        IOUtils.closeIgnoringException((Closeable)in);
        return (T)fSSaveable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(T t) throws FSServiceException {
        String folderPath = this.config.getStoreFolderPath(t.getOwnerId());
        String filePath = this.config.getStoreFilePath(t.getOwnerId());
        File file = new File(folderPath);
        if (!file.exists() && !file.mkdirs()) {
            throw new FSServiceException("FS_SERVICE: Can't create needed folder structure");
        }
        file = new File(filePath);
        ObjectOutputStream out = null;
        try {
            FSServiceImpl fSServiceImpl = this;
            synchronized (fSServiceImpl) {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out.writeObject(t);
                out.flush();
            }
        }
        catch (IOException ioe) {
            try {
                log.error((Object)("FS_SERVICE: IOException: " + ioe.getMessage()));
                throw new FSServiceException(ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringException(out);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringException((Closeable)out);
    }

    @Override
    public void delete(String ownerId) throws FSServiceException {
        String filePath = this.config.getStoreFilePath(ownerId);
        File f = new File(filePath);
        if (!f.exists()) {
            return;
        }
        if (!f.delete()) {
            throw new FSServiceException("Deletion filed. Owner id: " + ownerId + ". File path: " + filePath);
        }
    }
}

