/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.inmemorymirror;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.anoprise.inmemorymirror.ElementNotFoundException;
import net.anotheria.anoprise.inmemorymirror.InMemoryMirror;
import net.anotheria.anoprise.inmemorymirror.InMemoryMirrorException;
import net.anotheria.anoprise.inmemorymirror.InMemorySupport;
import net.anotheria.anoprise.inmemorymirror.Mirrorable;

public class InMemoryMirrorImpl<K, V extends Mirrorable<K>>
implements InMemoryMirror<K, V> {
    private InMemorySupport<K, V> support;
    private volatile Map<K, V> cache = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public InMemoryMirrorImpl(String configName, InMemorySupport<K, V> aSupport) {
        this.support = aSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> getAll() throws InMemoryMirrorException {
        this.getCache();
        try {
            this.lock.readLock().lock();
            ArrayList<V> arrayList = new ArrayList<V>(this.cache.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getCache() throws InMemoryMirrorException {
        try {
            this.lock.readLock().lock();
            if (this.cache != null) {
                Map<K, V> map = this.cache;
                return map;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.lock.writeLock().lock();
            if (this.cache != null) {
                Map<K, V> map = this.cache;
                return map;
            }
            Collection<V> fromSupport = this.support.readAll();
            HashMap map = new HashMap(fromSupport.size());
            for (Mirrorable v : fromSupport) {
                map.put(v.getKey(), v);
            }
            Map<K, V> map2 = this.cache = map;
            return map2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V get(K key) throws InMemoryMirrorException {
        Mirrorable ret = (Mirrorable)this.getCache().get(key);
        if (ret == null) {
            throw new ElementNotFoundException(key.toString());
        }
        return (V)ret;
    }

    @Override
    public V remove(K key) throws InMemoryMirrorException {
        return this.remove(key, false);
    }

    @Override
    public V removeLocalOnly(K id) throws InMemoryMirrorException {
        return this.remove(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V remove(K key, boolean localOnly) throws InMemoryMirrorException {
        try {
            this.lock.writeLock().lock();
            if (!localOnly) {
                this.support.remove(key);
            }
            Mirrorable mirrorable = (Mirrorable)this.getCache().remove(key);
            return (V)mirrorable;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void update(V element) throws InMemoryMirrorException {
        this.update(element, false);
    }

    @Override
    public void updateLocalOnly(V element) throws InMemoryMirrorException, ElementNotFoundException {
        this.update(element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(V element, boolean localOnly) throws InMemoryMirrorException {
        try {
            this.lock.writeLock().lock();
            if (!localOnly) {
                this.support.update(element);
            }
            this.getCache().put(element.getKey(), element);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V create(V element) throws InMemoryMirrorException {
        return this.create(element, false);
    }

    @Override
    public V createLocalOnly(V element) throws InMemoryMirrorException {
        return this.create(element, true);
    }

    protected V create(V element, boolean localOnly) throws InMemoryMirrorException {
        try {
            this.lock.writeLock().lock();
            V created = element;
            if (!localOnly) {
                created = this.support.create(element);
            }
            this.getCache().put(created.getKey(), created);
            V v = created;
            return v;
        }
        catch (Exception exception) {
            throw new InMemoryMirrorException("create(" + element + ")", exception);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

