/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.metafactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoprise.metafactory.AliasResolver;
import net.anotheria.anoprise.metafactory.ConfigurableFactoryResolver;
import net.anotheria.anoprise.metafactory.ConfigurableResolver;
import net.anotheria.anoprise.metafactory.Extension;
import net.anotheria.anoprise.metafactory.FactoryInstantiationError;
import net.anotheria.anoprise.metafactory.FactoryNotFoundException;
import net.anotheria.anoprise.metafactory.FactoryResolver;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import net.anotheria.anoprise.metafactory.OnTheFlyFactory;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import net.anotheria.anoprise.metafactory.SystemPropertyResolver;
import net.java.dev.moskito.core.util.storage.Storage;

public class MetaFactory {
    private static Map<String, Service> instances;
    private static Map<String, String> aliases;
    private static Map<String, Class<? extends ServiceFactory<? extends Service>>> factoryClasses;
    private static Map<String, ServiceFactory<? extends Service>> factories;
    private static List<AliasResolver> resolverList;
    private static FactoryResolver factoryResolver;

    public static void reset() {
        resolverList = new CopyOnWriteArrayList<AliasResolver>();
        resolverList.add(new SystemPropertyResolver());
        resolverList.add(ConfigurableResolver.create());
        factoryResolver = ConfigurableFactoryResolver.create();
        factoryClasses = Storage.createConcurrentHashMapStorage((String)"mf-factoryClasses");
        factories = Storage.createConcurrentHashMapStorage((String)"mf-factories");
        aliases = Storage.createConcurrentHashMapStorage((String)"mf-aliases");
        instances = Storage.createConcurrentHashMapStorage((String)"mf-instances");
    }

    public static <T extends Service> void resetInstances(Class<T> pattern) {
        String className = pattern.getName();
        for (String key : instances.keySet()) {
            if (!key.contains(className)) continue;
            instances.remove(key);
        }
    }

    public static <T extends Service> T create(Class<T> pattern, Extension extension) throws MetaFactoryException {
        return (T)((Service)pattern.cast(MetaFactory.create(extension.toName(pattern))));
    }

    public static <T extends Service> T create(Class<T> pattern) throws MetaFactoryException {
        return (T)((Service)pattern.cast(MetaFactory.create(pattern, Extension.NONE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Service> T create(String name) throws MetaFactoryException {
        ServiceFactory<? extends Service> factory = factories.get(name);
        if (factory != null) {
            return (T)factory.create();
        }
        Class<? extends ServiceFactory<? extends Service>> clazz = factoryClasses.get(name);
        if (clazz == null && (clazz = factoryResolver.resolveFactory(name)) != null) {
            MetaFactory.addFactoryClass(name, clazz);
        }
        if (clazz == null) {
            throw new FactoryNotFoundException(name);
        }
        Map<String, ServiceFactory<? extends Service>> map = factories;
        synchronized (map) {
            factory = factories.get(name);
            if (factory == null) {
                try {
                    factory = clazz.newInstance();
                    factories.put(name, factory);
                }
                catch (IllegalAccessException e) {
                    throw new FactoryInstantiationError(clazz, name, e.getMessage());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new FactoryInstantiationError(clazz, name, e.getMessage());
                }
            }
        }
        return (T)factory.create();
    }

    public static <T extends Service> T get(Class<T> pattern) throws MetaFactoryException {
        return MetaFactory.get(pattern, Extension.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Service> T get(Class<T> pattern, Extension extension) throws MetaFactoryException {
        MetaFactory.out("get called, pattern: " + pattern + ", extension: " + (Object)((Object)extension));
        if (extension == null) {
            extension = Extension.NONE;
        }
        String name = extension.toName(pattern);
        MetaFactory.out("name is " + name);
        name = MetaFactory.resolveAlias(name);
        MetaFactory.out("resolved alias to " + name);
        Service instance = (Service)pattern.cast(instances.get(name));
        MetaFactory.out("instance of " + name + " is: " + instance);
        if (instance != null) {
            return (T)instance;
        }
        Map<String, Service> map = instances;
        synchronized (map) {
            instance = (Service)pattern.cast(instances.get(name));
            if (instance == null) {
                MetaFactory.out("creating new instance of " + name);
                instance = (Service)pattern.cast(MetaFactory.create(name));
                MetaFactory.out("created new instance of " + name + " ---> " + instance);
                instances.put(name, instance);
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveAlias(String name) {
        List<AliasResolver> list = resolverList;
        synchronized (list) {
            for (AliasResolver resolver : resolverList) {
                String resolved = resolver.resolveAlias(name);
                if (resolved == null) continue;
                return MetaFactory.resolveAlias(resolved);
            }
        }
        String alias = aliases.get(name);
        return alias == null ? name : MetaFactory.resolveAlias(alias);
    }

    public static String resolveAlias(Class<? extends Service> clazz) {
        return MetaFactory.resolveAlias(clazz.getName());
    }

    public static void addAlias(String name, String alias) {
        aliases.put(alias, name);
    }

    public static <T extends Service> void addAlias(Class<T> pattern, Extension nameExtension) {
        MetaFactory.addAlias(pattern, nameExtension, null);
    }

    public static <T extends Service> void addAlias(Class<T> pattern, Extension nameExt, Extension aliasExtension) {
        if (nameExt == null) {
            nameExt = Extension.NONE;
        }
        if (aliasExtension == null) {
            aliasExtension = Extension.NONE;
        }
        MetaFactory.addAlias(nameExt.toName(pattern), aliasExtension.toName(pattern));
    }

    public static <T extends Service> void createOnTheFlyFactory(Class<T> service, Extension extension, T serviceInstance) {
        OnTheFlyFactory<T> factory = new OnTheFlyFactory<T>(serviceInstance);
        factories.put(extension.toName(service), factory);
    }

    public static <T extends Service> void addFactoryClass(Class<T> service, Extension extension, Class<? extends ServiceFactory<T>> factoryClass) {
        MetaFactory.addFactoryClass(extension.toName(service), factoryClass);
    }

    public static <T extends Service> void addFactoryClass(String name, Class<? extends ServiceFactory<T>> factoryClass) {
        factoryClasses.put(name, factoryClass);
    }

    private static void out(Object o) {
    }

    public static void debugDumpAliasMap() {
        Set<String> keys = aliases.keySet();
        for (String key : keys) {
            System.out.println(key + " = " + aliases.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAliasResolver(AliasResolver resolver) {
        List<AliasResolver> list = resolverList;
        synchronized (list) {
            for (int i = 0; i < resolverList.size(); ++i) {
                AliasResolver someResolver = resolverList.get(i);
                if (resolver.getPriority() >= someResolver.getPriority()) continue;
                resolverList.add(i, resolver);
                return;
            }
            resolverList.add(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AliasResolver> getAliasResolverList() {
        List<AliasResolver> list = resolverList;
        synchronized (list) {
            ArrayList<AliasResolver> ret = new ArrayList<AliasResolver>();
            ret.addAll(resolverList);
            return ret;
        }
    }

    static {
        MetaFactory.reset();
    }
}

