/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import net.anotheria.anoprise.queue.EnterpriseQueue;
import net.anotheria.anoprise.queue.EnterpriseQueueListener;
import net.anotheria.anoprise.queue.QueueEmptyException;
import net.anotheria.anoprise.queue.QueueOverflowException;
import net.java.dev.moskito.core.predefined.QueueStats;

public class EnterpriseQueueAdapter<T>
implements EnterpriseQueue<T> {
    private Queue<T> delegate;
    private int capacity;
    private List<EnterpriseQueueListener> listeners;
    private QueueStats queueStats;

    public EnterpriseQueueAdapter(Queue<T> aDelegateQueue) {
        this(aDelegateQueue, Integer.MAX_VALUE);
    }

    public EnterpriseQueueAdapter(BlockingQueue<T> aDelegateQueue, int aCapacity) {
        this((Queue<T>)aDelegateQueue, aCapacity);
    }

    private EnterpriseQueueAdapter(Queue<T> aDelegateQueue, int aCapacity) {
        this.delegate = aDelegateQueue;
        this.capacity = aCapacity;
        this.listeners = new ArrayList<EnterpriseQueueListener>();
        this.queueStats = new QueueStats(this.getClass().getSimpleName());
        this.queueStats.setTotalSize((long)aCapacity);
    }

    @Override
    public void addListener(EnterpriseQueueListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EnterpriseQueueListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public QueueStats getQueueStats() {
        return this.queueStats;
    }

    @Override
    public void add(T e) {
        if (!this.offer(e)) {
            throw new QueueOverflowException();
        }
    }

    @Override
    public boolean offer(T e) {
        this.queueStats.addRequest();
        this.queueStats.setOnRequestLastSize((long)this.delegate.size());
        boolean enqueued = this.delegate.offer(e);
        if (enqueued) {
            this.queueStats.addEnqueued();
        }
        return enqueued;
    }

    @Override
    public T remove() {
        T ret = this.poll();
        if (ret == null) {
            throw new QueueEmptyException();
        }
        return ret;
    }

    @Override
    public T poll() {
        T ret = this.delegate.poll();
        if (ret == null) {
            this.queueStats.addEmpty();
        } else {
            this.queueStats.addDequeued();
        }
        return ret;
    }

    @Override
    public T peek() {
        T ret = this.delegate.peek();
        if (ret == null) {
            this.queueStats.addEmpty();
        }
        return ret;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public List<T> drain() {
        ArrayList<T> ret = new ArrayList<T>();
        T element = this.delegate.poll();
        while (element != null) {
            ret.add(element);
            element = this.delegate.poll();
        }
        return ret;
    }
}

