/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionAttribute;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import net.anotheria.util.StringUtils;

public class DistributedSessionVO
implements Serializable {
    private static final long serialVersionUID = -2764699143075615769L;
    private static SessionDistributorServiceConfig serviceConfig = SessionDistributorServiceConfig.getInstance();
    private String name;
    private long lastChangeTime;
    private String userId;
    private String editorId;
    private Map<String, DistributedSessionAttribute> distributedAttributes;

    public DistributedSessionVO(String aName) {
        this.name = aName;
        this.distributedAttributes = new ConcurrentHashMap<String, DistributedSessionAttribute>();
        this.lastChangeTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    public void setLastChangeTime(long lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEditorId() {
        return this.editorId;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public Map<String, DistributedSessionAttribute> getDistributedAttributes() {
        return this.distributedAttributes;
    }

    public void setDistributedAttributes(Map<String, DistributedSessionAttribute> aDistributedAttributes) {
        if (aDistributedAttributes == null) {
            throw new IllegalArgumentException("distributedAttributes can't be null");
        }
        this.distributedAttributes = aDistributedAttributes;
    }

    public void addDistributedAttribute(DistributedSessionAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Distributed attribute can't be null");
        }
        this.distributedAttributes.put(attribute.getName(), attribute);
    }

    public void removeDistributedAttribute(String attributeName) {
        if (StringUtils.isEmpty((String)attributeName)) {
            throw new IllegalArgumentException("Distributed attribute name is illegal");
        }
        if (this.distributedAttributes.containsKey(attributeName)) {
            this.distributedAttributes.remove(attributeName);
        }
    }

    public String toString() {
        return "DistributedSessionVO{distributedAttributes size=" + this.distributedAttributes.size() + ", name='" + this.name + '\'' + ", lastChangeTime=" + (System.currentTimeMillis() - this.lastChangeTime) / 1000L + " seconds ago" + ", userId='" + this.userId + '\'' + ", editorId='" + this.editorId + '\'' + '}';
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.getLastChangeTime() > serviceConfig.getDistributedSessionMaxAge();
    }
}

