/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventServiceFactory;
import net.anotheria.anoprise.eventservice.EventServicePushConsumer;
import net.anotheria.anoprise.eventservice.util.QueuedEventReceiver;
import net.anotheria.anoprise.fs.FSSaveable;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionAttribute;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionVO;
import net.anotheria.anoprise.sessiondistributor.NoSuchDistributedSessionException;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import net.anotheria.anoprise.sessiondistributor.cache.events.SDCacheEvent;
import net.anotheria.anoprise.sessiondistributor.cache.events.SDCacheEventAnnouncer;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.StringUtils;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;
import org.apache.log4j.Logger;

public final class SDCache
implements FSSaveable {
    private static final long serialVersionUID = -1947015503980653358L;
    static final String DEFAULT_NODE_ID = "1000";
    private static final Logger LOG = Logger.getLogger(SDCache.class);
    private transient IdBasedLockManager lockManager;
    private transient SessionDistributorServiceConfig config;
    private transient SDCacheEventAnnouncer announcer;
    private transient String nodeId = "1000";
    private ConcurrentMap<String, DistributedSessionVO> sessions = new ConcurrentHashMap<String, DistributedSessionVO>();

    protected SDCache() {
        this.init();
    }

    private void init() {
        this.lockManager = new SafeIdBasedLockManager();
        this.config = SessionDistributorServiceConfig.getInstance();
        if (this.config.isMultipleInstancesEnabled()) {
            this.configureClusterIntegration();
        }
    }

    private void configureClusterIntegration() {
        LOG.info((Object)"Cluster integration configuration started");
        String systemPropertyNodeId = System.getProperty(this.config.getNodeIdSystemPropertyName());
        if (StringUtils.isEmpty((String)systemPropertyNodeId)) {
            LOG.warn((Object)("SD -  Cluster configuration FAILED. Required nodeId property[" + this.config.getNodeIdSystemPropertyName() + "] is absent in SystemProperties, or badly configured!" + " Working in standAlone mode!"));
            return;
        }
        this.nodeId = systemPropertyNodeId;
        this.announcer = new SDCacheEventAnnouncer();
        SDCacheEventsConsumer cacheConsumer = new SDCacheEventsConsumer();
        QueuedEventReceiver sdCacheEventReceiver = new QueuedEventReceiver("SDCacheEventReceiver", "SessionDistributorServiceCache", cacheConsumer, this.config.getSdCacheEventQueueSize(), this.config.getSessionDistributorEventQueueSleepTime(), LOG);
        EventServiceFactory.createEventService().obtainEventChannel("SessionDistributorServiceCache", sdCacheEventReceiver).addConsumer(cacheConsumer);
        sdCacheEventReceiver.start();
        LOG.info((Object)("Cluster integration stuff successfully configured! NodeId{" + this.nodeId + "}"));
    }

    public int getCount() {
        return this.sessions.size();
    }

    public List<DistributedSessionVO> getSessions() {
        return new ArrayList<DistributedSessionVO>(this.sessions.values());
    }

    public List<String> getSessionIds() {
        return new ArrayList<String>(this.sessions.keySet());
    }

    public boolean sessionExists(String sessionId) {
        return this.sessions.containsKey(sessionId);
    }

    public String createSession(String possibleSessionId) {
        DistributedSessionVO old;
        DistributedSessionVO toCreate = new DistributedSessionVO(possibleSessionId);
        if (!this.sessionExists(possibleSessionId)) {
            this.sessions.put(possibleSessionId, toCreate);
            this.announceSave(toCreate);
            return possibleSessionId;
        }
        do {
            toCreate.setName(IdCodeGenerator.generateCode((int)30));
        } while ((old = this.sessions.putIfAbsent(toCreate.getName(), toCreate)) != null);
        this.announceSave(toCreate);
        return toCreate.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String sessionId) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            this.sessions.remove(sessionId);
            this.announceDelete(session);
        }
        finally {
            lock.unlock();
        }
    }

    public DistributedSessionVO getSession(String sessionId) throws NoSuchDistributedSessionException {
        if (!this.sessionExists(sessionId) || this.sessions.get(sessionId) == null) {
            throw new NoSuchDistributedSessionException(sessionId);
        }
        return (DistributedSessionVO)this.sessions.get(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionUserId(String sessionId, String userId) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            session.setUserId(userId);
            session.setLastChangeTime(System.currentTimeMillis());
            this.announceSave(session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionEditorId(String sessionId, String editorId) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            session.setEditorId(editorId);
            session.setLastChangeTime(System.currentTimeMillis());
            this.announceSave(session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(String sessionId, DistributedSessionAttribute attribute) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            session.addDistributedAttribute(attribute);
            session.setLastChangeTime(System.currentTimeMillis());
            this.announceSave(session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String sessionId, String attribute) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            session.removeDistributedAttribute(attribute);
            session.setLastChangeTime(System.currentTimeMillis());
            this.announceSave(session);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCallTime(String sessionId) throws NoSuchDistributedSessionException {
        IdBasedLock lock = this.lockManager.obtainLock((Object)sessionId);
        lock.lock();
        try {
            DistributedSessionVO session = this.getSession(sessionId);
            session.setLastChangeTime(System.currentTimeMillis());
            this.announceSave(session);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String getOwnerId() {
        return this.nodeId;
    }

    public String toString() {
        return "SDCache{sessions-size=" + this.sessions.size() + ", ownerId='" + this.getOwnerId() + '\'' + '}';
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("sessions", this.sessions);
        oos.writeFields();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        this.sessions = (ConcurrentMap)fields.get("sessions", new ConcurrentHashMap());
        LOG.info((Object)"Reading persisted Sessions - started");
        long time = System.currentTimeMillis();
        for (DistributedSessionVO session : this.sessions.values()) {
            session.setLastChangeTime(time);
        }
        this.init();
        LOG.info((Object)("Reading persisted Sessions - completed! " + this.sessions.size() + "Read successfully, LastChangeTime updated!"));
    }

    private void announceSave(DistributedSessionVO session) {
        if (!this.config.isMultipleInstancesEnabled()) {
            return;
        }
        if (this.announcer == null) {
            return;
        }
        this.announcer.sessionSave(this.nodeId, session);
    }

    private void announceDelete(DistributedSessionVO session) {
        if (!this.config.isMultipleInstancesEnabled()) {
            return;
        }
        if (this.announcer == null) {
            return;
        }
        this.announcer.sessionDelete(this.nodeId, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String incomingNodeId, DistributedSessionVO session) {
        boolean isDebug = LOG.isDebugEnabled();
        if (isDebug) {
            LOG.debug((Object)("Called remove(" + incomingNodeId + "," + session + ")"));
        }
        if (this.nodeId.equals(incomingNodeId)) {
            return;
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)session.getName());
        lock.lock();
        try {
            try {
                DistributedSessionVO onCurrentNode = this.getSession(session.getName());
                if (onCurrentNode.getLastChangeTime() <= session.getLastChangeTime()) {
                    this.sessions.remove(session.getName());
                    if (isDebug) {
                        LOG.debug((Object)("Session[" + session.getName() + "] removed by delete event, on node[" + this.nodeId + "] - event comes from remote node[" + incomingNodeId + "] "));
                    }
                }
                if (isDebug) {
                    LOG.debug((Object)("Session[" + session.getName() + "] can't be removed by delete event, on node[" + this.nodeId + "], cause It is still in use!!!!! - " + "event comes by remote node[" + incomingNodeId + "] "));
                }
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn((Object)("NoSuchDistributedSessionException - occurred on delete try of session with name [" + session.getName() + "] on node : [" + this.nodeId + "]," + " -  deletion event comes from remote_node:[" + incomingNodeId + "]"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String incomingNodeId, DistributedSessionVO session) {
        boolean isDebug = LOG.isDebugEnabled();
        if (isDebug) {
            LOG.debug((Object)("Called save(" + incomingNodeId + "," + session + ")"));
        }
        if (this.nodeId.equals(incomingNodeId)) {
            return;
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)session.getName());
        lock.lock();
        try {
            try {
                DistributedSessionVO onCurrentNode = this.getSession(session.getName());
                if (onCurrentNode.getLastChangeTime() < session.getLastChangeTime()) {
                    this.sessions.put(session.getName(), session);
                    if (isDebug) {
                        LOG.debug((Object)("Session[" + session.getName() + "] updated on node[" + this.nodeId + "] by event from remote_node[" + incomingNodeId + "]"));
                    }
                }
            }
            catch (NoSuchDistributedSessionException e) {
                this.sessions.put(session.getName(), session);
                if (isDebug) {
                    LOG.debug((Object)("Session [" + session.getName() + "] created on node[" + this.nodeId + "], by event from remote_node[" + incomingNodeId + "]"));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private class SDCacheEventsConsumer
    implements EventServicePushConsumer {
        private final Logger log = Logger.getLogger(SDCacheEventsConsumer.class);

        private SDCacheEventsConsumer() {
        }

        @Override
        public void push(Event incomingEvent) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("SDCacheEvent : " + incomingEvent));
            }
            if (incomingEvent == null || incomingEvent.getData() == null || !(incomingEvent.getData() instanceof SDCacheEvent)) {
                return;
            }
            SDCacheEvent cacheEvent = (SDCacheEvent)SDCacheEvent.class.cast(incomingEvent.getData());
            switch (cacheEvent.getOperation()) {
                case CACHE_SESSION_SAVE: {
                    SDCache.this.save(cacheEvent.getClusterNodeId(), cacheEvent.getSession());
                    break;
                }
                case CACHE_SESSION_REMOVE: {
                    SDCache.this.remove(cacheEvent.getClusterNodeId(), cacheEvent.getSession());
                    break;
                }
                default: {
                    this.log.warn((Object)(cacheEvent.getOperation().name() + " NOT supported in current implementation"));
                }
            }
        }
    }
}

