/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor.cache.events;

import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannel;
import net.anotheria.anoprise.eventservice.EventServiceFactory;
import net.anotheria.anoprise.eventservice.EventServicePushSupplier;
import net.anotheria.anoprise.eventservice.util.QueueFullException;
import net.anotheria.anoprise.eventservice.util.QueuedEventSender;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionVO;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import net.anotheria.anoprise.sessiondistributor.cache.events.SDCacheEvent;
import org.apache.log4j.Logger;

public final class SDCacheEventAnnouncer
implements EventServicePushSupplier {
    public static final String EVENT_CHANNEL_NAME = "SessionDistributorServiceCache";
    public static final String ORIGINATOR = "-SessionDistributorCache-";
    private static final String JUNITTEST = "JUNITTEST";
    private QueuedEventSender eventSender;
    private static final Logger LOG = Logger.getLogger(SDCacheEventAnnouncer.class);

    public SDCacheEventAnnouncer() {
        SessionDistributorServiceConfig config = SessionDistributorServiceConfig.getInstance();
        EventChannel eventChannel = EventServiceFactory.createEventService().obtainEventChannel(EVENT_CHANNEL_NAME, this);
        boolean unitTesting = Boolean.valueOf(System.getProperty(JUNITTEST, String.valueOf(false)));
        this.eventSender = new QueuedEventSender("SessionDistributorServiceCache-sender", eventChannel, config.getSdCacheEventQueueSize(), config.getSdCacheEventQueueSleepTime(), LOG);
        if (unitTesting) {
            this.eventSender.setSynchedMode(true);
        } else {
            this.eventSender.start();
        }
    }

    public void sessionSave(String nodeId, DistributedSessionVO session) {
        this.deliver(SDCacheEvent.save(nodeId, session));
    }

    public void sessionDelete(String nodeId, DistributedSessionVO session) {
        this.deliver(SDCacheEvent.delete(nodeId, session));
    }

    private void deliver(SDCacheEvent eventData) {
        Event event = new Event(eventData);
        event.setOriginator(ORIGINATOR);
        try {
            this.eventSender.push(event);
        }
        catch (QueueFullException e) {
            LOG.error((Object)("Couldn't publish event due to queue overflow " + event));
        }
    }
}

