/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2;

import com.box.boxjavalibv2.ConnectionMonitor;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequest;
import com.box.restclientv2.interfaces.IBoxResponse;
import com.box.restclientv2.responses.DefaultBoxResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class BoxBasicRestClient
implements IBoxRESTClient {
    private final DefaultHttpClient mHttpClient;

    public HttpClient getRawHttpClient() {
        return this.mHttpClient;
    }

    public BoxBasicRestClient(int maxConnection, int maxConnectionPerRoute, long timePeriodCleanUpIdleConnection, long idleTimeThreshold) {
        ConnectionMonitor.setIdleTimeThreshold(idleTimeThreshold);
        ConnectionMonitor.setMaxConnection(maxConnectionPerRoute);
        ConnectionMonitor.setMaxConnectionPerRoute(maxConnectionPerRoute);
        ConnectionMonitor.setTimePeriodCleanUpIdleConnection(timePeriodCleanUpIdleConnection);
        ClientConnectionManager connectionManager = ConnectionMonitor.getConnectionManagerInstance();
        this.mHttpClient = new DefaultHttpClient(connectionManager, ConnectionMonitor.getHttpParams());
    }

    public BoxBasicRestClient() {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)5000);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute httpRoute) {
                return 100;
            }
        });
        SchemeRegistry schemeReg = new SchemeRegistry();
        schemeReg.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeReg.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager((HttpParams)params, schemeReg);
        this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
    }

    public IBoxResponse execute(IBoxRequest boxRequest) throws BoxRestException, AuthFatalFailureException {
        HttpResponse response;
        HttpUriRequest httpRequest = boxRequest.prepareRequest();
        try {
            response = this.getRawHttpClient().execute(httpRequest);
        }
        catch (Exception e) {
            throw new BoxRestException(e);
        }
        DefaultBoxResponse boxResponse = new DefaultBoxResponse(response);
        boxResponse.setExpectedResponseCode(boxRequest.getExpectedResponseCode());
        return boxResponse;
    }
}

