/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.ui.wizard;

import javax.annotation.concurrent.Immutable;
import net.java.truelicense.ui.wizard.WizardController;
import net.java.truelicense.ui.wizard.WizardModel;
import net.java.truelicense.ui.wizard.WizardView;

@Immutable
public abstract class BasicWizardController<S, V extends WizardView<S>>
implements WizardController {
    public static <S, V extends WizardView<S>> WizardController create(final WizardModel<S, V> wizardModel) {
        return new BasicWizardController<S, V>(){

            @Override
            protected WizardModel<S, V> model() {
                return wizardModel;
            }
        };
    }

    protected abstract WizardModel<S, V> model();

    @Override
    public final boolean switchBackEnabled() {
        return !this.backState().equals(this.currentState());
    }

    @Override
    public final void switchBack() {
        this.switchTo(this.backState());
    }

    @Override
    public final boolean switchNextEnabled() {
        return !this.nextState().equals(this.currentState());
    }

    @Override
    public final void switchNext() {
        this.switchTo(this.nextState());
    }

    private void switchTo(S s) {
        if (s.equals(this.currentState())) {
            return;
        }
        this.fireBeforeStateSwitch();
        this.currentState(s);
        this.fireAfterStateSwitch();
    }

    protected final void fireBeforeStateSwitch() {
        this.currentView().onBeforeStateSwitch();
        this.onBeforeStateSwitch();
    }

    protected void onBeforeStateSwitch() {
        this.beforeStateSwitch();
    }

    @Deprecated
    protected void beforeStateSwitch() {
    }

    protected final void fireAfterStateSwitch() {
        this.onAfterStateSwitch();
        this.currentView().onAfterStateSwitch();
    }

    protected void onAfterStateSwitch() {
        this.afterStateSwitch();
    }

    @Deprecated
    protected void afterStateSwitch() {
    }

    protected final V currentView() {
        return this.view(this.currentState());
    }

    protected final V view(S s) {
        return (V)((WizardView)this.model().view(s));
    }

    protected void view(S s, V v) {
        this.model().view(s, v);
    }

    protected final S currentState() {
        return this.model().currentState();
    }

    private void currentState(S s) {
        this.model().currentState(s);
    }

    protected final S backState() {
        return this.currentView().backState();
    }

    protected final S nextState() {
        return this.currentView().nextState();
    }
}

