/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.micronaut.internal;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Optional;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.micronaut.internal.LockingNotSupportedException;
import net.javacrumbs.shedlock.micronaut.internal.MicronautLockConfigurationExtractor;

@Singleton
public class SchedulerLockInterceptor
implements MethodInterceptor<Object, Object> {
    private final LockingTaskExecutor lockingTaskExecutor;
    private final MicronautLockConfigurationExtractor micronautLockConfigurationExtractor;

    public SchedulerLockInterceptor(LockProvider lockProvider, Optional<ConversionService<?>> conversionService, @Value(value="${shedlock.defaults.lock-at-most-for}") String defaultLockAtMostFor, @Value(value="${shedlock.defaults.lock-at-least-for:PT0S}") String defaultLockAtLeastFor) {
        ConversionService resolvedConversionService = conversionService.orElse(ConversionService.SHARED);
        this.lockingTaskExecutor = new DefaultLockingTaskExecutor(lockProvider);
        this.micronautLockConfigurationExtractor = new MicronautLockConfigurationExtractor((Duration)resolvedConversionService.convert((Object)defaultLockAtMostFor, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid 'defaultLockAtMostFor' value")), (Duration)resolvedConversionService.convert((Object)defaultLockAtLeastFor, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid 'defaultLockAtLeastFor' value")), resolvedConversionService);
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Class returnType = context.getReturnType().getType();
        if (!Void.TYPE.equals(returnType) && !Void.class.equals((Object)returnType)) {
            throw new LockingNotSupportedException();
        }
        Optional<LockConfiguration> lockConfiguration = this.micronautLockConfigurationExtractor.getLockConfiguration((ExecutableMethod<Object, Object>)context.getExecutableMethod());
        if (lockConfiguration.isPresent()) {
            this.lockingTaskExecutor.executeWithLock(() -> context.proceed(), lockConfiguration.get());
            return null;
        }
        return context.proceed();
    }
}

