/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery.specs;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import net.jqwik.engine.descriptor.DiscoverySupport;
import net.jqwik.engine.discovery.predicates.IsProperty;
import net.jqwik.engine.discovery.specs.DiscoverySpec;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.engine.support.hierarchical.Node;

public class PropertyDiscoverySpec
implements DiscoverySpec<Method> {
    private final IsProperty isProperty = new IsProperty();

    @Override
    public boolean shouldBeDiscovered(Method candidate) {
        return this.isProperty.test(candidate);
    }

    @Override
    public Node.SkipResult shouldBeSkipped(Method candidate) {
        if (ModifierSupport.isStatic((Member)candidate)) {
            return Node.SkipResult.skip((String)"A @Property method must not be static");
        }
        if (this.hasJupiterAnnotation(candidate)) {
            return Node.SkipResult.skip((String)String.format("A @Property method must not have JUnit annotations: %s", JqwikStringSupport.displayString(DiscoverySupport.findJUnitAnnotations(candidate))));
        }
        return Node.SkipResult.doNotSkip();
    }

    private boolean hasJupiterAnnotation(Method candidate) {
        return DiscoverySupport.findJUnitAnnotations(candidate).size() > 0;
    }
}

