/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.execution.GenerationInfo;
import net.jqwik.engine.execution.ParametersGenerator;

public class AfterFailureParametersGenerator
implements ParametersGenerator {
    private static final Logger LOG = Logger.getLogger(AfterFailureParametersGenerator.class.getName());
    private final GenerationInfo previousFailureGeneration;
    private final ParametersGenerator parametersGenerator;
    private boolean continueWithSeed = false;
    private boolean runWithPreviousSample = false;
    private boolean previousSampleHasJustRun = false;

    public AfterFailureParametersGenerator(AfterFailureMode afterFailureMode, GenerationInfo previousFailureGeneration, ParametersGenerator parametersGenerator) {
        this.logAfterFailureHandling(afterFailureMode, previousFailureGeneration);
        this.initializeRunningState(afterFailureMode, previousFailureGeneration);
        this.previousFailureGeneration = previousFailureGeneration;
        this.parametersGenerator = parametersGenerator;
    }

    private void initializeRunningState(AfterFailureMode afterFailureMode, GenerationInfo previousFailureGeneration) {
        if (this.shouldRunWithPreviousSample(afterFailureMode, previousFailureGeneration)) {
            this.runWithPreviousSample = true;
        }
        if (this.shouldContiueWithPreviousSeed(afterFailureMode)) {
            this.continueWithSeed = true;
        }
    }

    private boolean shouldContiueWithPreviousSeed(AfterFailureMode afterFailureMode) {
        return afterFailureMode == AfterFailureMode.SAMPLE_FIRST || afterFailureMode == AfterFailureMode.PREVIOUS_SEED;
    }

    private boolean shouldRunWithPreviousSample(AfterFailureMode afterFailureMode, GenerationInfo previousFailureGeneration) {
        return previousFailureGeneration.generationIndex() > 0 && (afterFailureMode == AfterFailureMode.SAMPLE_FIRST || afterFailureMode == AfterFailureMode.SAMPLE_ONLY);
    }

    private void logAfterFailureHandling(AfterFailureMode afterFailureMode, GenerationInfo previousFailureGeneration) {
        String message = String.format("After Failure Handling: %s, Previous Generation: <%s>", afterFailureMode, previousFailureGeneration);
        LOG.log(Level.INFO, message);
    }

    @Override
    public boolean hasNext() {
        if (this.runWithPreviousSample) {
            return true;
        }
        if (this.continueWithSeed) {
            return this.parametersGenerator.hasNext();
        }
        return false;
    }

    @Override
    public List<Shrinkable<Object>> next(TryLifecycleContext context) {
        if (this.runWithPreviousSample) {
            Optional<List<Shrinkable<Object>>> previousSample = this.generatePreviousSample(context);
            this.runWithPreviousSample = false;
            this.parametersGenerator.reset();
            if (previousSample.isPresent()) {
                this.previousSampleHasJustRun = true;
                return previousSample.get();
            }
            this.logFailingOfPreviousSampleGeneration();
            this.continueWithSeed = true;
            return this.next(context);
        }
        if (this.continueWithSeed) {
            this.previousSampleHasJustRun = false;
            return this.parametersGenerator.next(context);
        }
        return null;
    }

    private void logFailingOfPreviousSampleGeneration() {
        String message = String.format("Cannot generate previous falsified sample <%s>.%n\tUsing previous seed instead.", this.previousFailureGeneration);
        LOG.warning(message);
    }

    private Optional<List<Shrinkable<Object>>> generatePreviousSample(TryLifecycleContext context) {
        return this.previousFailureGeneration.generateOn(this.parametersGenerator, context);
    }

    @Override
    public int edgeCasesTotal() {
        return this.parametersGenerator.edgeCasesTotal();
    }

    @Override
    public int edgeCasesTried() {
        return this.parametersGenerator.edgeCasesTried();
    }

    @Override
    public GenerationInfo generationInfo(String randomSeed) {
        if (this.previousSampleHasJustRun) {
            return this.previousFailureGeneration;
        }
        return this.parametersGenerator.generationInfo(randomSeed);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Should only be used on delegate generators");
    }
}

