/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.InvokePropertyMethodHook;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CachingArbitraryResolver;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.execution.lifecycle.AroundTryLifecycle;
import net.jqwik.engine.execution.lifecycle.CurrentDomainContext;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.properties.CheckedFunction;
import net.jqwik.engine.properties.PropertyMethodArbitraryResolver;
import net.jqwik.engine.properties.PropertyMethodDataResolver;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;

public class CheckedPropertyFactory {
    public CheckedProperty fromDescriptor(PropertyMethodDescriptor propertyMethodDescriptor, PropertyLifecycleContext propertyLifecycleContext, AroundTryHook aroundTry, ResolveParameterHook parameterResolver, InvokePropertyMethodHook invokeMethod) {
        String propertyName = propertyMethodDescriptor.extendedLabel();
        Method propertyMethod = propertyMethodDescriptor.getTargetMethod();
        PropertyConfiguration configuration = propertyMethodDescriptor.getConfiguration();
        TryLifecycleExecutor tryLifecycleExecutor = this.createTryExecutor(propertyMethodDescriptor, propertyLifecycleContext, aroundTry, invokeMethod);
        List<MethodParameter> propertyParameters = this.extractParameters(propertyMethod, propertyMethodDescriptor.getContainerClass());
        PropertyMethodArbitraryResolver arbitraryResolver = new PropertyMethodArbitraryResolver(propertyLifecycleContext.testInstance(), CurrentDomainContext.get());
        Optional<Iterable<? extends Tuple>> optionalData = new PropertyMethodDataResolver(propertyMethodDescriptor.getContainerClass(), propertyLifecycleContext.testInstance()).forMethod(propertyMethodDescriptor.getTargetMethod());
        return new CheckedProperty(propertyName, tryLifecycleExecutor, propertyParameters, new CachingArbitraryResolver(arbitraryResolver), parameterResolver, propertyLifecycleContext, optionalData, configuration);
    }

    private TryLifecycleExecutor createTryExecutor(PropertyMethodDescriptor propertyMethodDescriptor, PropertyLifecycleContext propertyLifecycleContext, AroundTryHook aroundTry, InvokePropertyMethodHook invokeMethod) {
        AroundTryHook aroundTryWithFinishing = (context, aTry, parameters) -> {
            try {
                TryExecutionResult tryExecutionResult = aroundTry.aroundTry(context, aTry, parameters);
                return tryExecutionResult;
            }
            finally {
                StoreRepository.getCurrent().finishTry(propertyMethodDescriptor);
            }
        };
        TryExecutor rawExecutor = this.createRawExecutor(propertyLifecycleContext, invokeMethod);
        return new AroundTryLifecycle(rawExecutor, aroundTryWithFinishing);
    }

    private TryExecutor createRawExecutor(PropertyLifecycleContext propertyLifecycleContext, InvokePropertyMethodHook invokeMethod) {
        return this.createRawFunction(propertyLifecycleContext, invokeMethod);
    }

    private CheckedFunction createRawFunction(PropertyLifecycleContext propertyLifecycleContext, InvokePropertyMethodHook invokeMethod) {
        Method targetMethod = propertyLifecycleContext.targetMethod();
        Function<List, Object> function = params -> {
            try {
                return invokeMethod.invoke(targetMethod, propertyLifecycleContext.testInstance(), params.toArray());
            }
            catch (Throwable e) {
                return JqwikExceptionSupport.throwAsUncheckedException(e);
            }
        };
        return params -> {
            Object result = function.apply((List)params);
            return result == null || !Boolean.FALSE.equals(result);
        };
    }

    private List<MethodParameter> extractParameters(Method targetMethod, Class<?> containerClass) {
        return JqwikReflectionSupport.getMethodParameters(targetMethod, containerClass);
    }
}

