/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class AutoCloseableHook
implements AroundPropertyHook {
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        PropertyExecutionResult testExecutionResult = property.execute();
        this.executeCloseMethods(context);
        return testExecutionResult;
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public int aroundPropertyProximity() {
        return -100;
    }

    private void executeCloseMethods(PropertyLifecycleContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(ignore -> false);
        JqwikReflectionSupport.streamInstancesFromInside(context.testInstance()).forEach(innerInstance -> {
            if (innerInstance instanceof AutoCloseable) {
                throwableCollector.execute(((AutoCloseable)innerInstance)::close);
            }
        });
        throwableCollector.assertEmpty();
    }
}

