/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.types.TypeUsageImpl;

public class ExhaustiveShrinkablesGenerator
implements ForAllParametersGenerator {
    private final List<List<ExhaustiveGenerator<Object>>> generators;
    private final long maxCount;
    private Iterator<List<Shrinkable<Object>>> combinatorialIterator;

    public static ExhaustiveShrinkablesGenerator forParameters(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, long maxNumberOfSamples) {
        List<List<ExhaustiveGenerator<Object>>> exhaustiveGenerators = parameters.stream().map(parameter -> ExhaustiveShrinkablesGenerator.resolveParameter(arbitraryResolver, parameter, maxNumberOfSamples)).collect(Collectors.toList());
        return new ExhaustiveShrinkablesGenerator(exhaustiveGenerators);
    }

    private static List<ExhaustiveGenerator<Object>> resolveParameter(ArbitraryResolver arbitraryResolver, MethodParameter parameter, long maxNumberOfSamples) {
        Set<Arbitrary<?>> arbitraries = arbitraryResolver.forParameter(parameter);
        if (arbitraries.isEmpty()) {
            throw new CannotFindArbitraryException(TypeUsageImpl.forParameter(parameter), parameter.getAnnotation(ForAll.class));
        }
        ArrayList<ExhaustiveGenerator<Object>> exhaustiveGenerators = new ArrayList<ExhaustiveGenerator<Object>>();
        for (Arbitrary<?> arbitrary : arbitraries) {
            Optional optionalGenerator = arbitrary.exhaustive(maxNumberOfSamples);
            if (!optionalGenerator.isPresent()) {
                String message = String.format("Arbitrary %s does not provide exhaustive generator", arbitrary);
                throw new JqwikException(message);
            }
            exhaustiveGenerators.add((ExhaustiveGenerator<Object>)((ExhaustiveGenerator)optionalGenerator.get()));
        }
        return exhaustiveGenerators;
    }

    private ExhaustiveShrinkablesGenerator(List<List<ExhaustiveGenerator<Object>>> generators) {
        this.maxCount = generators.stream().mapToLong(set -> set.stream().mapToLong(ExhaustiveGenerator::maxCount).sum()).reduce((product, count) -> product * count).orElse(1L);
        this.generators = generators;
        this.reset();
    }

    private Iterator<List<Shrinkable<Object>>> combine(List<List<ExhaustiveGenerator<Object>>> generators) {
        final List iterables = generators.stream().map(this::concat).collect(Collectors.toList());
        return new Iterator<List<Shrinkable<Object>>>(){
            final Iterator<List<Object>> iterator;
            {
                this.iterator = Combinatorics.combine(iterables);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public List<Shrinkable<Object>> next() {
                ArrayList<Shrinkable<Object>> values = new ArrayList<Shrinkable<Object>>();
                for (Object o : this.iterator.next()) {
                    values.add((Shrinkable<Object>)Shrinkable.unshrinkable((Object)o));
                }
                return values;
            }
        };
    }

    private Iterable<Object> concat(List<ExhaustiveGenerator<Object>> generatorList) {
        List iterables = generatorList.stream().map(g -> g).collect(Collectors.toList());
        return () -> Combinatorics.concat(iterables);
    }

    @Override
    public boolean hasNext() {
        return this.combinatorialIterator.hasNext();
    }

    @Override
    public List<Shrinkable<Object>> next() {
        return this.combinatorialIterator.next();
    }

    @Override
    public void reset() {
        this.combinatorialIterator = this.combine(this.generators);
    }

    public long maxCount() {
        return this.maxCount;
    }
}

