/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;

public class FromGeneratorsArbitrary<T>
implements Arbitrary<T> {
    private final RandomGenerator<T> randomGenerator;
    private final Function<Long, Optional<ExhaustiveGenerator<T>>> exhaustiveGeneratorFunction;
    private final Function<Integer, EdgeCases<T>> edgeCasesSupplier;

    public FromGeneratorsArbitrary(RandomGenerator<T> randomGenerator, Function<Long, Optional<ExhaustiveGenerator<T>>> exhaustiveGeneratorFunction, Function<Integer, EdgeCases<T>> edgeCasesSupplier) {
        this.randomGenerator = randomGenerator;
        this.exhaustiveGeneratorFunction = exhaustiveGeneratorFunction;
        this.edgeCasesSupplier = edgeCasesSupplier;
    }

    public RandomGenerator<T> generator(int tries) {
        return this.randomGenerator;
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return this.exhaustiveGeneratorFunction.apply(maxNumberOfSamples);
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return maxEdgeCases <= 0 ? EdgeCases.none() : this.edgeCasesSupplier.apply(maxEdgeCases);
    }
}

