/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

public class RandomIntegralGenerators {
    public static RandomGenerator<BigInteger> bigIntegers(int genSize, BigInteger min, BigInteger max, BigInteger shrinkingTarget, RandomDistribution distribution) {
        Range<BigInteger> range = Range.of(min, max);
        RandomIntegralGenerators.checkTargetInRange(range, shrinkingTarget);
        if (range.isSingular()) {
            return ignored -> Shrinkable.unshrinkable((Object)((BigInteger)range.min));
        }
        RandomDistribution.RandomNumericGenerator numericGenerator = distribution.createGenerator(genSize, (BigInteger)range.min, (BigInteger)range.max, shrinkingTarget);
        return random -> {
            BigInteger value = numericGenerator.next(random);
            return new ShrinkableBigInteger(value, range, shrinkingTarget);
        };
    }

    private static void checkTargetInRange(Range<BigInteger> range, BigInteger value) {
        if (!range.includes(value)) {
            String message = String.format("Shrinking target <%s> is outside allowed range %s", value, range);
            throw new JqwikException(message);
        }
    }

    public static BigInteger defaultShrinkingTarget(Range<BigInteger> range) {
        if (range.includes(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        if (((BigInteger)range.max).compareTo(BigInteger.ZERO) < 0) {
            return (BigInteger)range.max;
        }
        if (((BigInteger)range.min).compareTo(BigInteger.ZERO) > 0) {
            return (BigInteger)range.min;
        }
        throw new RuntimeException("This should not be possible");
    }
}

