/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.recording;

import java.io.Serializable;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.execution.GenerationInfo;
import org.junit.platform.engine.UniqueId;

public class TestRun
implements Serializable {
    private final String uniqueIdString;
    private final int statusOrdinal;
    private final GenerationInfo generationInfo;

    public TestRun(UniqueId uniqueId, PropertyExecutionResult.Status status, GenerationInfo generationInfo) {
        this.uniqueIdString = uniqueId.toString();
        this.statusOrdinal = status.ordinal();
        this.generationInfo = generationInfo;
    }

    boolean hasUniqueId(UniqueId uniqueId) {
        return this.getUniqueId().equals((Object)uniqueId);
    }

    public boolean isNotSuccessful() {
        return this.getStatus() != PropertyExecutionResult.Status.SUCCESSFUL;
    }

    public UniqueId getUniqueId() {
        return UniqueId.parse((String)this.uniqueIdString);
    }

    public PropertyExecutionResult.Status getStatus() {
        return PropertyExecutionResult.Status.values()[this.statusOrdinal];
    }

    public GenerationInfo generationInfo() {
        return this.generationInfo;
    }

    public String toString() {
        return String.format("TestRun[%s:%s:%s]", this.uniqueIdString, this.getStatus(), this.generationInfo);
    }
}

