/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class HttpObject {
    private int objectNum;
    private Date start;
    private Date end;
    private long timeToFirstByte;
    private long timeToLastByte;
    private long bytes;
    private String url;
    private int responseCode;
    private String responseMessage;
    private String method;
    private String protocol;
    private String protocalVersion;
    private String host;
    private String path;
    private String queryString;
    private Map<String, String> requestHeaders;
    private Map<String, String> responseHeaders;
    private byte[] responseBytes;
    private String responseString;

    public HttpObject() {
    }

    public HttpObject(Date start, URL url, String method) {
        this.start = start;
        this.url = url.toExternalForm();
        this.method = method;
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.path = url.getPath();
        this.queryString = url.getQuery();
    }

    public void setObjectNum(int objectNum) {
        this.objectNum = objectNum;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void setTimeToLastByte(long timeToLastByte) {
        this.timeToLastByte = timeToLastByte;
    }

    public void setTimeToFirstByte(long timeToFirstByte) {
        this.timeToFirstByte = timeToFirstByte;
    }

    public int getObjectNum() {
        return this.objectNum;
    }

    public Date getStart() {
        return this.start;
    }

    public long getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    public long getTimeToLastByte() {
        return this.timeToLastByte;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String getUrl() {
        return this.url;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolVersion() {
        return this.protocalVersion;
    }

    public void setProtocolVersion(String protocalVersion) {
        this.protocalVersion = protocalVersion;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public Map<String, String> getResponseHeaders() {
        if (this.responseHeaders == null) {
            return new HashMap<String, String>();
        }
        return this.responseHeaders;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public Map<String, String> getRequestHeaders() {
        if (this.requestHeaders == null) {
            return new HashMap<String, String>();
        }
        return this.requestHeaders;
    }

    public byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public void setResponseContent(byte[] bytes) {
        this.responseBytes = bytes;
        try {
            this.responseString = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            this.responseString = new String(IOUtils.toByteArray((InputStream)new GZIPInputStream(new ByteArrayInputStream(this.responseBytes))), "UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

