/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.core.util.ThreadUtils;
import net.lightbody.bmp.proxy.BrowserMobProxyHandler;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.Server;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.util.Log;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.java_bandwidthlimiter.StreamManager;
import org.openqa.selenium.Proxy;

public class ProxyServer {
    private static final HarNameVersion CREATOR = new HarNameVersion("BrowserMob Proxy", "2.0");
    private static final Log LOG = new Log();
    private Server server;
    private int port = -1;
    private BrowserMobHttpClient client;
    private StreamManager streamManager;
    private HarPage currentPage;
    private BrowserMobProxyHandler handler;
    private int pageCount = 1;
    private AtomicInteger requestCounter = new AtomicInteger(0);

    public ProxyServer() {
    }

    public ProxyServer(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        if (this.port == -1) {
            throw new IllegalStateException("Must set port before starting");
        }
        this.streamManager = new StreamManager(100000000L);
        this.server = new Server();
        SocketListener listener = new SocketListener(new InetAddrPort(this.getPort()));
        this.server.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        this.server.addContext(context);
        this.handler = new BrowserMobProxyHandler();
        this.handler.setJettyServer(this.server);
        this.handler.setShutdownLock(new Object());
        this.client = new BrowserMobHttpClient(this.streamManager, this.requestCounter);
        this.client.prepareForBrowser();
        this.handler.setHttpClient(this.client);
        context.addHandler(this.handler);
        this.server.start();
        this.setPort(listener.getPort());
    }

    public Proxy seleniumProxy() throws UnknownHostException {
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        String proxyStr = String.format("%s:%d", InetAddress.getLocalHost().getCanonicalHostName(), this.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    public void cleanup() {
        this.handler.cleanup();
    }

    public void stop() throws Exception {
        this.cleanup();
        this.client.shutdown();
        this.server.stop();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Har getHar() {
        boolean success = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                return ProxyServer.this.requestCounter.get() == 0;
            }
        }, TimeUnit.SECONDS, 5L);
        if (!success) {
            LOG.warn("Waited 5 seconds for requests to cease before returning HAR; giving up!", new Object[0]);
        }
        return this.client.getHar();
    }

    public Har newHar(String initialPageRef) {
        this.pageCount = 1;
        Har oldHar = this.getHar();
        Har har = new Har(new HarLog(CREATOR));
        this.client.setHar(har);
        this.newPage(initialPageRef);
        return oldHar;
    }

    public void newPage(String pageRef) {
        if (pageRef == null) {
            pageRef = "Page " + this.pageCount;
        }
        this.client.setHarPageRef(pageRef);
        this.currentPage = new HarPage(pageRef);
        this.client.getHar().getLog().addPage(this.currentPage);
        ++this.pageCount;
    }

    public void endPage() {
        if (this.currentPage == null) {
            return;
        }
        this.currentPage.getPageTimings().setOnLoad(new Date().getTime() - this.currentPage.getStartedDateTime().getTime());
        this.client.setHarPageRef(null);
        this.currentPage = null;
    }

    public void setRetryCount(int count) {
        this.client.setRetryCount(count);
    }

    public void remapHost(String source, String target) {
        this.client.remapHost(source, target);
    }

    @Deprecated
    public void addRequestInterceptor(HttpRequestInterceptor i) {
        this.client.addRequestInterceptor(i);
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.client.addRequestInterceptor(interceptor);
    }

    @Deprecated
    public void addResponseInterceptor(HttpResponseInterceptor i) {
        this.client.addResponseInterceptor(i);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.client.addResponseInterceptor(interceptor);
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Deprecated
    public void setDownstreamKbps(long downstreamKbps) {
        this.streamManager.setDownstreamKbps(downstreamKbps);
        this.streamManager.enable();
    }

    @Deprecated
    public void setUpstreamKbps(long upstreamKbps) {
        this.streamManager.setUpstreamKbps(upstreamKbps);
        this.streamManager.enable();
    }

    @Deprecated
    public void setLatency(long latency) {
        this.streamManager.setLatency(latency);
        this.streamManager.enable();
    }

    public void setRequestTimeout(int requestTimeout) {
        this.client.setRequestTimeout(requestTimeout);
    }

    public void setSocketOperationTimeout(int readTimeout) {
        this.client.setSocketOperationTimeout(readTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.client.setConnectionTimeout(connectionTimeout);
    }

    public void autoBasicAuthorization(String domain, String username, String password) {
        this.client.autoBasicAuthorization(domain, username, password);
    }

    public void rewriteUrl(String match, String replace) {
        this.client.rewriteUrl(match, replace);
    }

    public void blacklistRequests(String pattern, int responseCode) {
        this.client.blacklistRequests(pattern, responseCode);
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        this.client.whitelistRequests(patterns, responseCode);
    }

    public void addHeader(String name, String value) {
        this.client.addHeader(name, value);
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.client.setCaptureHeaders(captureHeaders);
    }

    public void setCaptureContent(boolean captureContent) {
        this.client.setCaptureContent(captureContent);
    }

    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.client.setCaptureBinaryContent(captureBinaryContent);
    }

    public void clearDNSCache() {
        this.client.clearDNSCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.client.setDNSCacheTimeout(timeout);
    }

    public void waitForNetworkTrafficToStop(final long quietPeriodInMs, long timeoutInMs) {
        long start = System.currentTimeMillis();
        boolean result = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                Date lastCompleted = null;
                Har har = ProxyServer.this.client.getHar();
                if (har == null || har.getLog() == null) {
                    return true;
                }
                for (HarEntry entry : har.getLog().getEntries()) {
                    if (entry.getResponse().getStatus() < 0) {
                        return false;
                    }
                    Date end = new Date(entry.getStartedDateTime().getTime() + entry.getTime());
                    if (lastCompleted == null) {
                        lastCompleted = end;
                        continue;
                    }
                    if (!end.after(lastCompleted)) continue;
                    lastCompleted = end;
                }
                return lastCompleted != null && System.currentTimeMillis() - lastCompleted.getTime() >= quietPeriodInMs;
            }
        }, TimeUnit.MILLISECONDS, timeoutInMs);
        long end = System.currentTimeMillis();
        long time = end - start;
        if (!result) {
            throw new RuntimeException("Timed out after " + timeoutInMs + " ms while waiting for network traffic to stop");
        }
    }

    public void setOptions(Map<String, String> options) {
        if (options.containsKey("httpProxy")) {
            this.client.setHttpProxy(options.get("httpProxy"));
        }
    }
}

