/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.bricks;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.sitebricks.At;
import com.google.sitebricks.client.transport.Json;
import com.google.sitebricks.headless.Reply;
import com.google.sitebricks.headless.Request;
import com.google.sitebricks.headless.Service;
import com.google.sitebricks.http.Delete;
import com.google.sitebricks.http.Get;
import com.google.sitebricks.http.Post;
import com.google.sitebricks.http.Put;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.proxy.ProxyManager;
import net.lightbody.bmp.proxy.ProxyServer;
import net.lightbody.bmp.proxy.http.BrowserMobHttpRequest;
import net.lightbody.bmp.proxy.http.BrowserMobHttpResponse;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.util.Log;
import org.java_bandwidthlimiter.StreamManager;

@At(value="/proxy")
@Service
public class ProxyResource {
    private static final Log LOG = new Log();
    private ProxyManager proxyManager;

    @Inject
    public ProxyResource(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Post
    public Reply<ProxyDescriptor> newProxy(Request request) throws Exception {
        String systemProxyHost = System.getProperty("http.proxyHost");
        String systemProxyPort = System.getProperty("http.proxyPort");
        String httpProxy = request.param("httpProxy");
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (httpProxy != null) {
            options.put("httpProxy", httpProxy);
        } else if (systemProxyHost != null && systemProxyPort != null) {
            options.put("httpProxy", String.format("%s:%s", systemProxyHost, systemProxyPort));
        }
        String paramPort = request.param("port");
        int port = 0;
        if (paramPort != null) {
            port = Integer.parseInt(paramPort);
            ProxyServer proxy = this.proxyManager.create(options, port);
        } else {
            ProxyServer proxy = this.proxyManager.create(options);
            port = proxy.getPort();
        }
        return Reply.with((Object)new ProxyDescriptor(port)).as(Json.class);
    }

    @Get
    @At(value="/:port/har")
    public Reply<Har> getHar(@Named(value="port") int port) {
        ProxyServer proxy = this.proxyManager.get(port);
        Har har = proxy.getHar();
        return Reply.with((Object)har).as(Json.class);
    }

    @Put
    @At(value="/:port/har")
    public Reply<?> newHar(@Named(value="port") int port, Request request) {
        String initialPageRef = request.param("initialPageRef");
        ProxyServer proxy = this.proxyManager.get(port);
        Har oldHar = proxy.newHar(initialPageRef);
        String captureHeaders = request.param("captureHeaders");
        String captureContent = request.param("captureContent");
        String captureBinaryContent = request.param("captureBinaryContent");
        proxy.setCaptureHeaders(Boolean.parseBoolean(captureHeaders));
        proxy.setCaptureContent(Boolean.parseBoolean(captureContent));
        proxy.setCaptureBinaryContent(Boolean.parseBoolean(captureBinaryContent));
        if (oldHar != null) {
            return Reply.with((Object)oldHar).as(Json.class);
        }
        return Reply.saying().noContent();
    }

    @Put
    @At(value="/:port/har/pageRef")
    public Reply<?> setPage(@Named(value="port") int port, Request request) {
        String pageRef = request.param("pageRef");
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.newPage(pageRef);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/blacklist")
    public Reply<?> blacklist(@Named(value="port") int port, Request request) {
        String blacklist = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.blacklistRequests(blacklist, responseCode);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/whitelist")
    public Reply<?> whitelist(@Named(value="port") int port, Request request) {
        String regex = request.param("regex");
        int responseCode = this.parseResponseCode(request.param("status"));
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.whitelistRequests(regex.split(","), responseCode);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/auth/basic/:domain")
    public Reply<?> autoBasicAuth(@Named(value="port") int port, @Named(value="domain") String domain, Request request) {
        Map credentials = (Map)request.read(HashMap.class).as(Json.class);
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.autoBasicAuthorization(domain, (String)credentials.get("username"), (String)credentials.get("password"));
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/headers")
    public Reply<?> updateHeaders(@Named(value="port") int port, Request request) {
        ProxyServer proxy = this.proxyManager.get(port);
        Map headers = (Map)request.read(Map.class).as(Json.class);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            proxy.addHeader(key, value);
        }
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/interceptor/response")
    public Reply<?> addResponseInterceptor(@Named(value="port") int port, Request request) throws IOException, ScriptException {
        ProxyServer proxy = this.proxyManager.get(port);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.readTo((OutputStream)baos);
        ScriptEngineManager mgr = new ScriptEngineManager();
        final ScriptEngine engine = mgr.getEngineByName("JavaScript");
        Compilable compilable = (Compilable)((Object)engine);
        final CompiledScript script = compilable.compile(baos.toString());
        proxy.addResponseInterceptor(new ResponseInterceptor(){

            @Override
            public void process(BrowserMobHttpResponse response) {
                Bindings bindings = engine.createBindings();
                bindings.put("response", (Object)response);
                bindings.put("log", (Object)LOG);
                try {
                    script.eval(bindings);
                }
                catch (ScriptException e) {
                    LOG.severe("Could not execute JS-based response interceptor", e);
                }
            }
        });
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/interceptor/request")
    public Reply<?> addRequestInterceptor(@Named(value="port") int port, Request request) throws IOException, ScriptException {
        ProxyServer proxy = this.proxyManager.get(port);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.readTo((OutputStream)baos);
        ScriptEngineManager mgr = new ScriptEngineManager();
        final ScriptEngine engine = mgr.getEngineByName("JavaScript");
        Compilable compilable = (Compilable)((Object)engine);
        final CompiledScript script = compilable.compile(baos.toString());
        proxy.addRequestInterceptor(new RequestInterceptor(){

            @Override
            public void process(BrowserMobHttpRequest request) {
                Bindings bindings = engine.createBindings();
                bindings.put("request", (Object)request);
                bindings.put("log", (Object)LOG);
                try {
                    script.eval(bindings);
                }
                catch (ScriptException e) {
                    LOG.severe("Could not execute JS-based response interceptor", e);
                }
            }
        });
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/limit")
    public Reply<?> limit(@Named(value="port") int port, Request request) {
        String enable;
        String maxBitsPerSecond;
        String payloadPercentage;
        String latency;
        String downstreamKbps;
        ProxyServer proxy = this.proxyManager.get(port);
        StreamManager streamManager = proxy.getStreamManager();
        String upstreamKbps = request.param("upstreamKbps");
        if (upstreamKbps != null) {
            try {
                streamManager.setUpstreamKbps(Integer.parseInt(upstreamKbps));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((downstreamKbps = request.param("downstreamKbps")) != null) {
            try {
                streamManager.setDownstreamKbps(Integer.parseInt(downstreamKbps));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((latency = request.param("latency")) != null) {
            try {
                streamManager.setLatency(Integer.parseInt(latency));
                streamManager.enable();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((payloadPercentage = request.param("payloadPercentage")) != null) {
            try {
                streamManager.setPayloadPercentage(Integer.parseInt(payloadPercentage));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((maxBitsPerSecond = request.param("maxBitsPerSecond")) != null) {
            try {
                streamManager.setMaxBitsPerSecondThreshold(Integer.parseInt(maxBitsPerSecond));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((enable = request.param("enable")) != null) {
            if (Boolean.parseBoolean(enable)) {
                streamManager.enable();
            } else {
                streamManager.disable();
            }
        }
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/timeout")
    public Reply<?> timeout(@Named(value="port") int port, Request request) {
        String dnsCacheTimeout;
        String connectionTimeout;
        String readTimeout;
        ProxyServer proxy = this.proxyManager.get(port);
        String requestTimeout = request.param("requestTimeout");
        if (requestTimeout != null) {
            try {
                proxy.setRequestTimeout(Integer.parseInt(requestTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((readTimeout = request.param("readTimeout")) != null) {
            try {
                proxy.setSocketOperationTimeout(Integer.parseInt(readTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((connectionTimeout = request.param("connectionTimeout")) != null) {
            try {
                proxy.setConnectionTimeout(Integer.parseInt(connectionTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((dnsCacheTimeout = request.param("dnsCacheTimeout")) != null) {
            try {
                proxy.setDNSCacheTimeout(Integer.parseInt(dnsCacheTimeout));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port")
    public Reply<?> delete(@Named(value="port") int port) throws Exception {
        this.proxyManager.delete(port);
        return Reply.saying().ok();
    }

    @Post
    @At(value="/:port/hosts")
    public Reply<?> remapHosts(@Named(value="port") int port, Request request) {
        ProxyServer proxy = this.proxyManager.get(port);
        Map headers = (Map)request.read(Map.class).as(Json.class);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            proxy.remapHost(key, value);
            proxy.setDNSCacheTimeout(0);
            proxy.clearDNSCache();
        }
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/wait")
    public Reply<?> wait(@Named(value="port") int port, Request request) {
        String quietPeriodInMs = request.param("quietPeriodInMs");
        String timeoutInMs = request.param("timeoutInMs");
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.waitForNetworkTrafficToStop(Integer.parseInt(quietPeriodInMs), Integer.parseInt(timeoutInMs));
        return Reply.saying().ok();
    }

    @Delete
    @At(value="/:port/dns/cache")
    public Reply<?> clearDnsCache(@Named(value="port") int port) throws Exception {
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.clearDNSCache();
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/rewrite")
    public Reply<?> rewriteUrl(@Named(value="port") int port, Request request) {
        String match = request.param("matchRegex");
        String replace = request.param("replace");
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.rewriteUrl(match, replace);
        return Reply.saying().ok();
    }

    @Put
    @At(value="/:port/retry")
    public Reply<?> retryCount(@Named(value="port") int port, Request request) {
        String count = request.param("retrycount");
        ProxyServer proxy = this.proxyManager.get(port);
        proxy.setRetryCount(Integer.parseInt(count));
        return Reply.saying().ok();
    }

    private int parseResponseCode(String response) {
        int responseCode = 200;
        if (response != null) {
            try {
                responseCode = Integer.parseInt(response);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return responseCode;
    }

    public static class ProxyDescriptor {
        private int port;

        public ProxyDescriptor() {
        }

        public ProxyDescriptor(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

