/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import cz.mallat.uasparser.OnlineUpdateUASparser;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.lightbody.bmp.proxy.guice.NamedImpl;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;

public class ConfigModule
implements Module {
    private String[] args;

    public ConfigModule(String[] args) {
        this.args = args;
    }

    public void configure(Binder binder) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec portSpec = parser.accepts("port", "The port to listen on").withOptionalArg().ofType(Integer.class).defaultsTo((Object)8080, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec userAgentCacheSpec = parser.accepts("uaCache", "The number of days to cache a database of User-Agent records from http://user-agent-string.info").withOptionalArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        parser.acceptsAll(Arrays.asList("help", "?"), "This help text");
        OptionSet options = parser.parse(this.args);
        if (options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        binder.bind(Key.get(Integer.class, (Annotation)((Object)new NamedImpl("port")))).toInstance(portSpec.value(options));
        Integer userAgentCacheDays = (Integer)userAgentCacheSpec.value(options);
        if (BrowserMobHttpClient.PARSER instanceof OnlineUpdateUASparser) {
            ((OnlineUpdateUASparser)BrowserMobHttpClient.PARSER).setUpdateInterval(86400000 * userAgentCacheDays);
        }
    }
}

