/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import net.lightbody.bmp.core.har.HarEntry;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class BrowserMobHttpResponse {
    private HarEntry entry;
    private HttpRequestBase method;
    private HttpResponse response;
    private boolean contentMatched;
    private String verificationText;
    private String errorMessage;
    private String body;
    private String contentType;
    private String charSet;

    public BrowserMobHttpResponse(HarEntry entry, HttpRequestBase method, HttpResponse response, boolean contentMatched, String verificationText, String errorMessage, String body, String contentType, String charSet) {
        this.entry = entry;
        this.method = method;
        this.response = response;
        this.contentMatched = contentMatched;
        this.verificationText = verificationText;
        this.errorMessage = errorMessage;
        this.body = body;
        this.contentType = contentType;
        this.charSet = charSet;
    }

    public boolean isContentMatched() {
        return this.contentMatched;
    }

    public String getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public HttpResponse getRawResponse() {
        return this.response;
    }

    public void checkContentMatched(String info) {
        if (!this.isContentMatched()) {
            throw new RuntimeException("Content match failure. Expected '" + this.verificationText + "'." + (info != null ? " " + info : ""));
        }
    }

    public HarEntry getEntry() {
        return this.entry;
    }
}

