/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.lightbody.bmp.core.har.HarCookie;
import net.lightbody.bmp.core.har.HarNameValuePair;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class CookieHeadersParser {
    public List<HarCookie> getCookies(HttpRequest request) {
        LinkedList cookies = Lists.newLinkedList();
        for (Header hdr : request.getHeaders("Cookie")) {
            String[] pairs;
            for (String p : pairs = hdr.getValue().split("; ")) {
                HarNameValuePair pair = this.nameValuePair(p);
                HarCookie cookie = new HarCookie();
                cookie.setName(pair.getName());
                cookie.setValue(pair.getValue());
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    private HarNameValuePair nameValuePair(String data) {
        int eqIdx = data.indexOf("=");
        if (eqIdx > 0) {
            String name = data.substring(0, eqIdx);
            String val = data.substring(eqIdx + 1);
            return new HarNameValuePair(name, val);
        }
        return new HarNameValuePair(data, "");
    }
}

