/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.util.Date;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarTimings;
import net.lightbody.bmp.proxy.util.Log;

public class RequestInfo {
    private static final Log LOG = new Log();
    private static ThreadLocal<RequestInfo> instance = new ThreadLocal<RequestInfo>(){

        @Override
        protected RequestInfo initialValue() {
            return new RequestInfo();
        }
    };
    private Long blocked;
    private Long dns;
    private Long connect;
    private Long ssl;
    private Long send;
    private Long wait;
    private Long receive;
    private String resolvedAddress;
    private Date start;
    private Date end;
    private String url;
    private HarEntry entry;

    public static RequestInfo get() {
        return instance.get();
    }

    public static void clear(String url, HarEntry entry) {
        RequestInfo.clear();
        RequestInfo info = RequestInfo.get();
        info.url = url;
        info.entry = entry;
    }

    private static void clear() {
        RequestInfo info = RequestInfo.get();
        info.blocked = null;
        info.dns = null;
        info.connect = null;
        info.ssl = null;
        info.send = null;
        info.wait = null;
        info.receive = null;
        info.resolvedAddress = null;
        info.start = null;
        info.end = null;
    }

    private Long ping(Date start, Date end) {
        if (this.start == null) {
            this.start = start;
        } else if (this.start.after(start)) {
            LOG.severe("Saw a later start time that was before the first start time for URL %s", this.url);
        }
        return end.getTime() - start.getTime();
    }

    public Long getBlocked() {
        return null;
    }

    public Long getDns() {
        return this.dns;
    }

    public Long getConnect() {
        return this.connect;
    }

    public Long getSsl() {
        return this.ssl;
    }

    public Long getSend() {
        return this.send;
    }

    public Long getWait() {
        return this.wait;
    }

    public Long getReceive() {
        return this.receive;
    }

    public String getResolvedAddress() {
        return this.resolvedAddress;
    }

    public void blocked(Date start, Date end) {
        this.blocked = end.getTime() - start.getTime();
    }

    public void dns(Date start, Date end, String resolvedAddress) {
        this.dns = this.ping(start, end);
        this.resolvedAddress = resolvedAddress;
    }

    public void connect(Date start, Date end) {
        this.connect = this.ping(start, end);
    }

    public void ssl(Date start, Date end) {
        this.ssl = this.ping(start, end);
    }

    public void send(Date start, Date end) {
        this.send = this.ping(start, end);
    }

    public void wait(Date start, Date end) {
        this.wait = this.ping(start, end);
    }

    public void finish() {
        this.end = new Date();
        if (this.start == null) {
            this.start = new Date();
        }
        long totalTime = this.end.getTime() - this.start.getTime();
        this.receive = totalTime - this.norm(this.wait) - this.norm(this.send) - this.norm(this.ssl) - this.norm(this.connect) - this.norm(this.dns);
        if (this.norm(this.ssl) > 0L) {
            this.connect = this.connect + this.ssl;
        }
        if (this.receive < 0L) {
            LOG.severe("Got a negative receiving time (%d) for URL %s", this.receive, this.url);
            this.receive = 0L;
        }
    }

    private long norm(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public long getTotalTime() {
        if (this.end == null || this.start == null) {
            return -1L;
        }
        return this.end.getTime() - this.start.getTime();
    }

    public String toString() {
        long totalTime = this.end.getTime() - this.start.getTime();
        return "RequestInfo{blocked=" + this.blocked + ", dns=" + this.dns + ", connect=" + this.connect + ", ssl=" + this.ssl + ", send=" + this.send + ", wait=" + this.wait + ", receive=" + this.receive + ", total=" + totalTime + ", resolvedAddress='" + this.resolvedAddress + '\'' + '}';
    }

    public HarTimings getTimings() {
        long send = 0L;
        if (this.send != null) {
            send = this.send;
        }
        long wait = 0L;
        if (this.wait != null) {
            wait = this.wait;
        }
        long receive = 0L;
        if (this.receive != null) {
            receive = this.receive;
        }
        long blocked = 0L;
        if (this.blocked != null) {
            blocked = this.blocked;
        }
        long dns = 0L;
        if (this.dns != null) {
            dns = this.dns;
        }
        long connect = 0L;
        if (this.connect != null) {
            connect = this.connect;
        }
        return new HarTimings(blocked, dns, connect, send, wait, receive);
    }

    public HarEntry getEntry() {
        return this.entry;
    }
}

